/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.common;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;

public class ImageButton
extends FocusPanel {
    private final Image img;
    private final Image disabledImg;
    private ClickHandler clickHandler;
    private HandlerRegistration handlerRegistration;

    @UiConstructor
    public ImageButton(Image img) {
        this.add((Widget)img);
        this.img = img;
        this.disabledImg = img;
        this.setStyleName("image-Button");
    }

    public ImageButton(Image img, Image disabledImg, String tooltip) {
        this.add((Widget)img);
        this.img = img;
        this.disabledImg = disabledImg;
        this.setStyleName("image-Button");
        this.setTitle(tooltip);
    }

    public ImageButton(Image img, Image disabledImg) {
        this.add((Widget)img);
        this.img = img;
        this.disabledImg = disabledImg;
        this.setStyleName("image-Button");
    }

    public ImageButton(Image img, String tooltip) {
        this.add((Widget)img);
        this.img = img;
        this.disabledImg = img;
        this.setStyleName("image-Button");
        this.setTitle(tooltip);
    }

    public ImageButton(Image img, String tooltip, ClickHandler clickHandler) {
        this(img, tooltip);
        this.clickHandler = clickHandler;
        this.assertClickHandler();
    }

    public ImageButton(Image img, Image disabledImg, String tooltip, ClickHandler clickHandler) {
        this(img, disabledImg, tooltip);
        this.clickHandler = clickHandler;
        this.assertClickHandler();
    }

    public void setEnabled(boolean enabled) {
        this.clear();
        if (enabled) {
            this.add((Widget)this.img);
            this.assertClickHandler();
        } else {
            this.add((Widget)this.disabledImg);
            this.removeClickHandler();
        }
    }

    private void assertClickHandler() {
        if (this.clickHandler != null && this.handlerRegistration == null) {
            this.handlerRegistration = this.addClickHandler(this.clickHandler);
        }
    }

    private void removeClickHandler() {
        if (this.handlerRegistration != null) {
            this.handlerRegistration.removeHandler();
            this.handlerRegistration = null;
        }
    }
}

