/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.tables;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.user.cellview.client.AbstractPager;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasRows;
import com.google.gwt.view.client.Range;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.uberfire.ext.widgets.common.client.resources.UberfireSimplePagerResources;
import org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants;

public class UberfireSimplePager
extends AbstractPager {
    private static int DEFAULT_FAST_FORWARD_ROWS = 100;
    private static UberfireSimplePagerResources DEFAULT_RESOURCES;
    private final Button fastForward;
    private final int fastForwardRows;
    private final Button firstPage;
    private final HTML label = new HTML();
    private final Button lastPage;
    private final Button nextPage;
    private final Button prevPage;
    private final UberfireSimplePagerResources resources;
    private final Style style;
    private int pageSize = 10;

    private static UberfireSimplePagerResources getDefaultResources() {
        if (DEFAULT_RESOURCES == null) {
            DEFAULT_RESOURCES = UberfireSimplePagerResources.INSTANCE;
        }
        return DEFAULT_RESOURCES;
    }

    public UberfireSimplePager() {
        this(TextLocation.CENTER);
    }

    public UberfireSimplePager(TextLocation location) {
        this(location, UberfireSimplePager.getDefaultResources(), true, DEFAULT_FAST_FORWARD_ROWS, true);
    }

    public UberfireSimplePager(boolean showFastForwardButton, boolean showLastPageButton) {
        this(TextLocation.CENTER, UberfireSimplePager.getDefaultResources(), showFastForwardButton, DEFAULT_FAST_FORWARD_ROWS, showLastPageButton);
    }

    public UberfireSimplePager(TextLocation location, UberfireSimplePagerResources resources, boolean showFastForwardButton, int fastForwardRows, boolean showLastPageButton) {
        this.resources = resources;
        this.fastForwardRows = fastForwardRows;
        this.style = resources.simplePagerStyle();
        this.style.ensureInjected();
        this.firstPage = new Button();
        this.firstPage.setIcon(IconType.ANGLE_DOUBLE_LEFT);
        this.firstPage.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                UberfireSimplePager.this.firstPage();
            }
        });
        this.nextPage = new Button();
        this.nextPage.setIcon(IconType.ANGLE_RIGHT);
        this.nextPage.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                UberfireSimplePager.this.nextPage();
            }
        });
        this.prevPage = new Button();
        this.prevPage.setIcon(IconType.ANGLE_LEFT);
        this.prevPage.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                UberfireSimplePager.this.previousPage();
            }
        });
        this.lastPage = new Button();
        this.lastPage.setIcon(IconType.ANGLE_DOUBLE_RIGHT);
        this.lastPage.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                UberfireSimplePager.this.lastPage();
            }
        });
        this.fastForward = new Button();
        this.fastForward.setIcon(IconType.FAST_FORWARD);
        this.fastForward.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                UberfireSimplePager.this.setPage(UberfireSimplePager.this.getPage() + UberfireSimplePager.this.getFastForwardPages());
            }
        });
        HorizontalPanel layout = new HorizontalPanel();
        layout.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        this.initWidget((Widget)layout);
        if (location == TextLocation.RIGHT) {
            layout.add((Widget)this.label);
        }
        layout.add((Widget)this.firstPage);
        layout.add((Widget)this.prevPage);
        if (location == TextLocation.CENTER) {
            layout.add((Widget)this.label);
        }
        layout.add((Widget)this.nextPage);
        layout.add((Widget)this.fastForward);
        layout.add((Widget)this.lastPage);
        if (location == TextLocation.LEFT) {
            layout.add((Widget)this.label);
        }
        this.firstPage.getElement().getParentElement().addClassName(this.style.button());
        this.prevPage.getElement().getParentElement().addClassName(this.style.button());
        this.label.getElement().getParentElement().addClassName(this.style.pageDetails());
        this.nextPage.getElement().getParentElement().addClassName(this.style.button());
        this.fastForward.getElement().getParentElement().addClassName(this.style.button());
        this.lastPage.getElement().getParentElement().addClassName(this.style.button());
        this.setShowLastPageButton(showLastPageButton);
        this.setShowFastFordwardPageButton(showFastForwardButton);
        this.setDisplay(null);
    }

    public void setShowLastPageButton(boolean showLastPageButton) {
        this.lastPage.setVisible(showLastPageButton);
    }

    public void setShowFastFordwardPageButton(boolean showFastFordwardPageButton) {
        this.fastForward.setVisible(showFastFordwardPageButton);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void nextPage() {
        if (this.getDisplay() != null) {
            Range range = this.getDisplay().getVisibleRange();
            this.setPageStart(range.getStart() + this.getPageSize());
        }
    }

    public void previousPage() {
        if (this.getDisplay() != null) {
            Range range = this.getDisplay().getVisibleRange();
            this.setPageStart(range.getStart() - this.getPageSize());
        }
    }

    public void setDisplay(HasRows display) {
        boolean disableButtons = display == null;
        this.setFastForwardDisabled(disableButtons);
        this.setNextPageButtonsDisabled(disableButtons);
        this.setPrevPageButtonsDisabled(disableButtons);
        super.setDisplay(display);
    }

    public void setPage(int index) {
        super.setPage(index);
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
        super.setPageSize(pageSize);
    }

    public void setPageStart(int index) {
        if (this.getDisplay() != null) {
            Range range = this.getDisplay().getVisibleRange();
            int displayPageSize = range.getLength();
            if (!this.isRangeLimited() && this.getDisplay().isRowCountExact()) {
                index = Math.min(index, this.getDisplay().getRowCount() - displayPageSize);
            }
            if ((index = Math.max(0, index)) != range.getStart()) {
                this.getDisplay().setVisibleRange(index, displayPageSize);
            }
        }
    }

    public void startLoading() {
        this.getDisplay().setRowCount(0, true);
        this.label.setHTML("");
    }

    private int getFastForwardPages() {
        int pageSize = this.getPageSize();
        return pageSize > 0 ? this.fastForwardRows / pageSize : 0;
    }

    private void setFastForwardDisabled(boolean disabled) {
        if (this.fastForward == null) {
            return;
        }
        this.fastForward.setEnabled(!disabled);
    }

    private void setNextPageButtonsDisabled(boolean disabled) {
        this.nextPage.setEnabled(!disabled);
        if (this.lastPage != null) {
            this.lastPage.setEnabled(!disabled);
        }
    }

    private void setPrevPageButtonsDisabled(boolean disabled) {
        this.firstPage.setEnabled(!disabled);
        this.prevPage.setEnabled(!disabled);
    }

    protected String createText() {
        NumberFormat formatter = NumberFormat.getFormat((String)"#,###");
        HasRows display = this.getDisplay();
        Range range = display.getVisibleRange();
        int pageStart = range.getStart() + 1;
        int pageSize = range.getLength();
        int dataSize = display.getRowCount();
        int endIndex = Math.min(dataSize, pageStart + pageSize - 1);
        endIndex = Math.max(pageStart, endIndex);
        boolean exact = display.isRowCountExact();
        if (dataSize == 0) {
            return "0 " + this.of() + " 0";
        }
        if (pageStart == endIndex) {
            return formatter.format((double)pageStart) + " " + this.of() + " " + formatter.format((double)dataSize);
        }
        return formatter.format((double)pageStart) + "-" + formatter.format((double)endIndex) + (exact ? " " + this.of() + " " : " " + this.of() + " " + this.over() + " ") + formatter.format((double)dataSize);
    }

    protected void onRangeOrRowCountChanged() {
        HasRows display = this.getDisplay();
        this.label.setText(this.createText());
        this.setPrevPageButtonsDisabled(!this.hasPreviousPage());
        if (this.isRangeLimited() || !display.isRowCountExact()) {
            this.setNextPageButtonsDisabled(!this.hasNextPage());
            this.setFastForwardDisabled(!this.hasNextPages(this.getFastForwardPages()));
        }
    }

    boolean isNextButtonDisabled() {
        return !this.nextPage.isEnabled();
    }

    boolean isPreviousButtonDisabled() {
        return !this.prevPage.isEnabled();
    }

    private String of() {
        return CommonConstants.INSTANCE.Of();
    }

    private String over() {
        return CommonConstants.INSTANCE.Over();
    }

    public static enum TextLocation {
        CENTER,
        LEFT,
        RIGHT;

    }

    public static interface Style
    extends CssResource {
        public String button();

        public String pageDetails();
    }
}

