/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.dropdown;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchDropDown;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchService;
import org.uberfire.ext.widgets.common.client.dropdown.PerspectiveNameProvider;
import org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants;
import org.uberfire.mvp.Command;

@Dependent
public class PerspectiveDropDown
implements IsWidget {
    SyncBeanManager iocManager;
    LiveSearchDropDown liveSearchDropDown;
    PerspectiveNameProvider perspectiveNameProvider;
    Set<String> perspectiveIdsExcluded;
    LiveSearchService searchService = (pattern, maxResults, callback) -> {
        List<String> result = new ArrayList<String>();
        for (SyncBeanDef beanDef : this.iocManager.lookupBeans(PerspectiveActivity.class)) {
            PerspectiveActivity p = (PerspectiveActivity)beanDef.getInstance();
            try {
                String name;
                if (this.perspectiveIdsExcluded != null && this.perspectiveIdsExcluded.contains(p.getIdentifier()) || !(name = this.getItemName(p)).toLowerCase().contains(pattern.toLowerCase())) continue;
                result.add(name);
            }
            finally {
                this.iocManager.destroyBean((Object)p);
            }
        }
        if (maxResults > 0 && maxResults < result.size()) {
            result = result.subList(0, maxResults);
        }
        Collections.sort(result);
        callback.afterSearch(result);
    };

    @Inject
    public PerspectiveDropDown(SyncBeanManager iocManager, LiveSearchDropDown liveSearchDropDown) {
        this.iocManager = iocManager;
        this.liveSearchDropDown = liveSearchDropDown;
        this.perspectiveNameProvider = null;
    }

    @PostConstruct
    private void init() {
        this.liveSearchDropDown.setSelectorHint(CommonConstants.INSTANCE.PerspectiveSelectHint());
        this.liveSearchDropDown.setSearchHint(CommonConstants.INSTANCE.PerspectiveSearchHint());
        this.liveSearchDropDown.setNotFoundMessage(CommonConstants.INSTANCE.PerspectiveNotFound());
        this.liveSearchDropDown.setSearchService(this.searchService);
    }

    public Widget asWidget() {
        return this.liveSearchDropDown.asWidget();
    }

    public void setPerspectiveNameProvider(PerspectiveNameProvider perspectiveNameProvider) {
        this.perspectiveNameProvider = perspectiveNameProvider;
    }

    public void setPerspectiveIdsExcluded(Set<String> perspectiveIdsExcluded) {
        this.perspectiveIdsExcluded = perspectiveIdsExcluded;
    }

    public PerspectiveActivity getDefaultPerspective() {
        for (SyncBeanDef beanDef : this.iocManager.lookupBeans(PerspectiveActivity.class)) {
            PerspectiveActivity p = (PerspectiveActivity)beanDef.getInstance();
            if (!p.isDefault()) continue;
            return p;
        }
        return null;
    }

    public PerspectiveActivity getSelectedPerspective() {
        String selected = this.liveSearchDropDown.getSelectedItem();
        if (selected == null) {
            return null;
        }
        for (SyncBeanDef beanDef : this.iocManager.lookupBeans(PerspectiveActivity.class)) {
            PerspectiveActivity p = (PerspectiveActivity)beanDef.getInstance();
            String name = this.getItemName(p);
            if (!selected.equals(name)) continue;
            return p;
        }
        return null;
    }

    public void setSelectedPerspective(PerspectiveActivity selectedPerspective) {
        String item = this.getItemName(selectedPerspective);
        this.liveSearchDropDown.setSelectedItem(item);
    }

    public void setSelectedPerspective(String perspectiveId) {
        String item = this.getItemName(perspectiveId);
        this.liveSearchDropDown.setSelectedItem(item);
    }

    public void setMaxItems(int maxItems) {
        this.liveSearchDropDown.setMaxItems(maxItems);
    }

    public void setWidth(int minWidth) {
        this.liveSearchDropDown.setWidth(minWidth);
    }

    public void setOnChange(Command onChange) {
        this.liveSearchDropDown.setOnChange(onChange);
    }

    public void clear() {
        this.liveSearchDropDown.clear();
    }

    public String getItemName(PerspectiveActivity p) {
        return this.getItemName(p.getIdentifier());
    }

    public String getItemName(String perspectiveId) {
        if (this.perspectiveNameProvider != null) {
            return this.perspectiveNameProvider.getPerspectiveName(perspectiveId);
        }
        String fullName = perspectiveId;
        int lastDot = fullName.lastIndexOf(".");
        return lastDot != -1 ? fullName.substring(lastDot + 1) : fullName;
    }
}

