/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.tables;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.gwt.DataGrid;
import org.uberfire.ext.services.shared.preferences.GridColumnPreference;
import org.uberfire.ext.services.shared.preferences.GridPreferencesStore;
import org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants;
import org.uberfire.ext.widgets.table.client.ColumnMeta;
import org.uberfire.ext.widgets.table.client.UberfireColumnPicker;

public class ColumnPicker<T>
extends UberfireColumnPicker<T> {
    private GridPreferencesStore gridPreferences;

    public ColumnPicker(DataGrid<T> dataGrid, GridPreferencesStore gridPreferences) {
        super(dataGrid);
        this.gridPreferences = gridPreferences;
    }

    public ColumnPicker(DataGrid<T> dataGrid) {
        super(dataGrid);
    }

    protected void sortAndAddColumns(List<ColumnMeta<T>> columnMetas) {
        this.updateColumnsMeta(columnMetas);
        super.sortAndAddColumns(columnMetas);
    }

    private void updateColumnsMeta(List<ColumnMeta<T>> columnMetas) {
        for (ColumnMeta<T> meta : columnMetas) {
            this.checkColumnMeta(meta);
        }
    }

    protected void checkColumnMeta(ColumnMeta<T> columnMeta) {
        if (this.gridPreferences != null) {
            List columnPreferences = this.gridPreferences.getColumnPreferences();
            if (!columnPreferences.isEmpty()) {
                boolean found = false;
                for (int i = 0; i < this.gridPreferences.getColumnPreferences().size() && !found; ++i) {
                    GridColumnPreference gcp = (GridColumnPreference)this.gridPreferences.getColumnPreferences().get(i);
                    if (!gcp.getName().equals(this.getColumnStoreName(columnMeta))) continue;
                    columnMeta.setVisible(true);
                    if (gcp.getWidth() != null) {
                        this.dataGrid.setColumnWidth(columnMeta.getColumn(), gcp.getWidth());
                    } else {
                        this.dataGrid.setColumnWidth(columnMeta.getColumn(), 100.0, Style.Unit.PCT);
                    }
                    columnMeta.setPosition(gcp.getPosition().intValue());
                    found = true;
                }
                if (!found) {
                    columnMeta.setPosition(-1);
                    columnMeta.setVisible(false);
                }
            } else if (this.gridPreferences.getGlobalPreferences() != null) {
                int position = this.gridPreferences.getGlobalPreferences().getInitialColumns().indexOf(this.getColumnStoreName(columnMeta));
                if (position != -1) {
                    columnMeta.setVisible(true);
                    columnMeta.setPosition(position);
                } else {
                    columnMeta.setPosition(-1);
                    columnMeta.setVisible(false);
                }
            }
        }
    }

    public void setGridPreferencesStore(GridPreferencesStore gridPreferences) {
        this.gridPreferences = gridPreferences;
    }

    protected void addResetButtom(int left, int top, VerticalPanel popupContent) {
        if (this.gridPreferences != null) {
            Button resetButton = (Button)GWT.create(Button.class);
            resetButton.setText(CommonConstants.INSTANCE.Reset());
            resetButton.setSize(ButtonSize.EXTRA_SMALL);
            resetButton.addClickHandler(event -> this.resetTableColumns(left, top));
            popupContent.add((Widget)resetButton);
        }
    }

    protected boolean addThisColumnToPopup(ColumnMeta<T> columnMeta) {
        return this.gridPreferences == null || !this.gridPreferences.getGlobalPreferences().getBannedColumns().contains(this.getColumnStoreName(columnMeta));
    }

    protected void loadGlobalGridPreferences() {
        this.gridPreferences.resetGridColumnPreferences();
        for (ColumnMeta columnMeta : this.columnMetaList) {
            int position = this.gridPreferences.getGlobalPreferences().getInitialColumns().indexOf(this.getColumnStoreName(columnMeta));
            columnMeta.setPosition(position);
            columnMeta.setVisible(position > -1);
        }
    }

    public List<GridColumnPreference> getColumnsState() {
        ArrayList<GridColumnPreference> state = new ArrayList<GridColumnPreference>();
        for (ColumnMeta cm : this.columnMetaList) {
            if (!cm.isVisible()) continue;
            state.add(new GridColumnPreference(this.getColumnStoreName(cm), Integer.valueOf(this.dataGrid.getColumnIndex(cm.getColumn())), this.dataGrid.getColumnWidth(cm.getColumn())));
        }
        return state;
    }

    public void adjustColumnWidths() {
        super.adjustColumnWidths();
        List<GridColumnPreference> preferences = this.getColumnsState();
        if (preferences.isEmpty()) {
            return;
        }
        if (preferences.size() == 1) {
            this.dataGrid.setColumnWidth(this.dataGrid.getColumn(0), 100.0, Style.Unit.PCT);
            return;
        }
        int fixedColumnsWidth = 0;
        HashMap<String, String> fixedWidths = new HashMap<String, String>();
        ArrayList<String> columnsToCalculate = new ArrayList<String>();
        for (GridColumnPreference preference : preferences) {
            if (preference.getWidth() != null && preference.getWidth().endsWith(Style.Unit.PX.getType())) {
                fixedWidths.put(preference.getName(), preference.getWidth());
                fixedColumnsWidth += Integer.decode(preference.getWidth().substring(0, preference.getWidth().indexOf(Style.Unit.PX.getType()))).intValue();
                continue;
            }
            columnsToCalculate.add(preference.getName());
        }
        if (columnsToCalculate.size() > 0) {
            double columnPCT = 100 / columnsToCalculate.size() + 1;
            if (this.dataGrid.getOffsetWidth() != 0) {
                int availableColumnSpace = this.dataGrid.getOffsetWidth() - fixedColumnsWidth;
                double availablePCT = availableColumnSpace * 100 / this.dataGrid.getOffsetWidth();
                columnPCT = columnPCT * availablePCT / 100.0;
            }
            for (ColumnMeta cm : this.columnMetaList) {
                if (!cm.isVisible()) continue;
                if (columnsToCalculate.contains(this.getColumnStoreName(cm))) {
                    this.dataGrid.setColumnWidth(cm.getColumn(), columnPCT, Style.Unit.PCT);
                    continue;
                }
                this.dataGrid.setColumnWidth(cm.getColumn(), (String)fixedWidths.get(this.getColumnStoreName(cm)));
            }
        }
    }
}

