/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.tables;

import com.google.common.base.Strings;
import com.google.gwt.cell.client.AbstractSafeHtmlCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Style;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.text.shared.SafeHtmlRenderer;
import com.google.gwt.text.shared.SimpleSafeHtmlRenderer;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;

public class PopoverTextCell
extends AbstractSafeHtmlCell<String> {
    private Placement placement;

    public PopoverTextCell(Placement placement) {
        super((SafeHtmlRenderer)SimpleSafeHtmlRenderer.getInstance(), new String[]{"mouseover", "mouseout"});
        this.placement = placement;
    }

    public PopoverTextCell() {
        this(Placement.AUTO);
    }

    protected void render(Cell.Context context, SafeHtml data, SafeHtmlBuilder sb) {
        this.hideAllPopover();
        String content = data.asString();
        if (Strings.isNullOrEmpty((String)content)) {
            return;
        }
        Element div = DOM.createDiv();
        div.setId(DOM.createUniqueId());
        div.setInnerHTML(content);
        div.getStyle().setOverflow(Style.Overflow.HIDDEN);
        div.getStyle().setTextOverflow(Style.TextOverflow.ELLIPSIS);
        div.getStyle().setWhiteSpace(Style.WhiteSpace.NOWRAP);
        String html = div.getString();
        sb.appendHtmlConstant(html);
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand((com.google.gwt.dom.client.Element)div){
            final /* synthetic */ com.google.gwt.dom.client.Element val$div;
            {
                this.val$div = element;
            }

            public void execute() {
                PopoverTextCell.this.initPopover(this.val$div.getId(), PopoverTextCell.this.placement.name().toLowerCase());
            }
        });
    }

    public void onBrowserEvent(Cell.Context context, final com.google.gwt.dom.client.Element parent, String value, NativeEvent event, ValueUpdater<String> valueUpdater) {
        super.onBrowserEvent(context, parent, (Object)value, event, valueUpdater);
        com.google.gwt.dom.client.Element element = com.google.gwt.dom.client.Element.as((JavaScriptObject)event.getEventTarget());
        if (!DivElement.is((com.google.gwt.dom.client.Element)element)) {
            return;
        }
        if ("mouseover".equals(event.getType())) {
            Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                public void execute() {
                    PopoverTextCell.this.showPopover(parent.getFirstChildElement().getId());
                }
            });
        } else if ("mouseout".equals(event.getType())) {
            this.hidePopover(parent.getFirstChildElement().getId());
        }
    }

    private native void hideAllPopover();

    private native void hidePopover(String var1);

    private native void showPopover(String var1);

    private native void initPopover(String var1, String var2);

    public static enum Placement {
        LEFT,
        TOP,
        AUTO,
        BOTTOM,
        RIGHT;

    }
}

