/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.core.client.editors.texteditor;

import com.google.gwt.user.client.ui.IsWidget;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.ext.widgets.common.client.ace.AceEditorMode;
import org.uberfire.ext.widgets.core.client.resources.i18n.CoreConstants;
import org.uberfire.lifecycle.IsDirty;
import org.uberfire.lifecycle.OnStartup;

public abstract class TextEditorPresenter {
    @Inject
    public View view;
    @Inject
    private Caller<VFSService> vfsServices;
    protected Path path;

    @OnStartup
    public void onStartup(ObservablePath path) {
        this.path = path;
        ((VFSService)this.vfsServices.call((RemoteCallback)new RemoteCallback<String>(){

            public void callback(String response) {
                if (response == null) {
                    TextEditorPresenter.this.view.setContent(CoreConstants.INSTANCE.EmptyEntry(), TextEditorPresenter.this.getAceEditorMode());
                } else {
                    TextEditorPresenter.this.view.setContent(response, TextEditorPresenter.this.getAceEditorMode());
                }
                TextEditorPresenter.this.onAfterViewLoaded();
            }
        })).readAllString((Path)path);
    }

    protected void onAfterViewLoaded() {
    }

    public AceEditorMode getAceEditorMode() {
        return AceEditorMode.TEXT;
    }

    @IsDirty
    public boolean isDirty() {
        return this.view.isDirty();
    }

    public void onOpen() {
        this.view.setFocus();
    }

    public IsWidget getWidget() {
        return this.view;
    }

    public static interface View
    extends IsWidget {
        public void setContent(String var1, AceEditorMode var2);

        public String getContent();

        public void setFocus();

        public void setDirty(boolean var1);

        public boolean isDirty();

        public void setReadOnly(boolean var1);
    }
}

