/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.core.client.editors.defaulteditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;
import java.util.Map;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.ext.widgets.common.client.common.FileUpload;
import org.uberfire.ext.widgets.core.client.resources.i18n.CoreConstants;
import org.uberfire.mvp.Command;

public abstract class DefaultEditorFileUploadBase
extends Composite {
    private static DefaultEditorFileUploadBaseBinder uiBinder = (DefaultEditorFileUploadBaseBinder)GWT.create(DefaultEditorFileUploadBaseBinder.class);
    @UiField
    FormPanel form;
    @UiField(provided=true)
    FileUpload fileUpload;

    public DefaultEditorFileUploadBase() {
        this(true);
    }

    public DefaultEditorFileUploadBase(boolean showUpload) {
        this.fileUpload = this.createFileUpload(showUpload);
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.initForm();
    }

    void initForm() {
        this.form.setEncoding("multipart/form-data");
        this.form.setMethod("post");
        this.form.addSubmitHandler(new FormPanel.SubmitHandler(){

            public void onSubmit(FormPanel.SubmitEvent event) {
                String fileName = DefaultEditorFileUploadBase.this.fileUpload.getFilename();
                if (this.isNullOrEmpty(fileName)) {
                    BusyPopup.close();
                    Window.alert((String)CoreConstants.INSTANCE.SelectFileToUpload());
                    event.cancel();
                }
            }

            private boolean isNullOrEmpty(String fileName) {
                return fileName == null || "".equals(fileName);
            }
        });
        this.form.addSubmitCompleteHandler(new FormPanel.SubmitCompleteHandler(){

            public void onSubmitComplete(FormPanel.SubmitCompleteEvent event) {
                if ("OK".equalsIgnoreCase(event.getResults())) {
                    Window.alert((String)CoreConstants.INSTANCE.UploadSuccess());
                } else if ("FAIL".equalsIgnoreCase(event.getResults())) {
                    Window.alert((String)CoreConstants.INSTANCE.UploadFail());
                }
                BusyPopup.close();
            }
        });
    }

    private FileUpload createFileUpload(boolean showUpload) {
        return new FileUpload(new Command(){

            public void execute() {
                DefaultEditorFileUploadBase.this.form.setAction(GWT.getModuleBaseURL() + "defaulteditor/upload" + DefaultEditorFileUploadBase.this.createParametersForURL());
                DefaultEditorFileUploadBase.this.form.submit();
            }
        }, showUpload);
    }

    private String createParametersForURL() {
        String parameters = "?";
        Map<String, String> map = this.getParameters();
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String parameter = iterator.next();
            parameters = parameters + parameter + "=" + map.get(parameter);
            if (!iterator.hasNext()) continue;
            parameters = parameters + "&";
        }
        return parameters;
    }

    protected abstract Map<String, String> getParameters();

    public void upload() {
        this.fileUpload.upload();
    }

    static interface DefaultEditorFileUploadBaseBinder
    extends UiBinder<FormPanel, DefaultEditorFileUploadBase> {
    }
}

