/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.core.client.wizards;

import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.core.client.wizards.Wizard;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageSelectedEvent;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;
import org.uberfire.ext.widgets.core.client.wizards.WizardView;

public abstract class AbstractWizard
implements Wizard {
    @Inject
    private WizardView view;
    private boolean isStarted = false;

    @PostConstruct
    public void setup() {
        this.view.init(this);
    }

    public void onStatusChange(@Observes WizardPageStatusChangeEvent event) {
        if (!this.isStarted) {
            return;
        }
        List<WizardPage> wps = this.getPages();
        if (!wps.contains(event.getPage())) {
            return;
        }
        this.checkPagesState();
    }

    private void checkPagesState() {
        List<WizardPage> wps = this.getPages();
        for (WizardPage wp : wps) {
            final int index = wps.indexOf(wp);
            wp.isComplete(new Callback<Boolean>(){

                public void callback(Boolean result) {
                    AbstractWizard.this.view.setPageCompletionState(index, Boolean.TRUE.equals(result));
                }
            });
        }
        this.isComplete(new Callback<Boolean>(){

            public void callback(Boolean result) {
                AbstractWizard.this.view.setCompletionStatus(Boolean.TRUE.equals(result));
            }
        });
    }

    public void onPageSelected(@Observes WizardPageSelectedEvent event) {
        if (!this.isStarted) {
            return;
        }
        WizardPage page = event.getSelectedPage();
        int index = this.getPages().indexOf(page);
        this.view.selectPage(index);
    }

    @Override
    public void start() {
        this.isStarted = true;
        this.view.setTitle(this.getTitle());
        this.view.setPreferredHeight(this.getPreferredHeight());
        this.view.setPreferredWidth(this.getPreferredWidth());
        this.view.setPageTitles(this.getPages());
        this.checkPagesState();
        this.view.selectPage(0);
        this.view.show();
    }

    @Override
    public void pageSelected(int pageNumber) {
        Widget w = this.getPageWidget(pageNumber);
        this.view.setBodyWidget(w);
    }

    @Override
    public void close() {
        this.view.hide();
    }

    @Override
    public void complete() {
        this.view.hide();
    }
}

