/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.core.client.wizards;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.container.IOCBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.core.client.wizards.AbstractWizard;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageTitle;
import org.uberfire.ext.widgets.core.client.wizards.WizardPopupFooter;
import org.uberfire.ext.widgets.core.client.wizards.WizardView;

@Dependent
public class WizardViewImpl
extends BaseModal
implements WizardView {
    @Inject
    private SyncBeanManager iocBeanManager;
    @UiField
    protected VerticalPanel sideBar;
    @UiField
    protected SimplePanel sideBarContainer;
    @UiField
    protected SimplePanel body;
    @UiField
    protected ScrollPanel bodyContainer;
    protected WizardPopupFooter footer;
    private List<WizardPageTitle> pageTitleWidgets = new ArrayList<WizardPageTitle>();
    private int pageNumber;
    private int pageNumberTotal;
    private AbstractWizard presenter;
    private static WizardActivityViewImplBinder uiBinder = (WizardActivityViewImplBinder)GWT.create(WizardActivityViewImplBinder.class);

    public WizardViewImpl() {
        this.footer = new WizardPopupFooter(new Command(){

            public void execute() {
                if (WizardViewImpl.this.pageNumber == 0) {
                    return;
                }
                WizardViewImpl.this.selectPage(WizardViewImpl.this.pageNumber - 1);
                WizardViewImpl.this.footer.setPreviousButtonFocus(false);
            }
        }, new Command(){

            public void execute() {
                if (WizardViewImpl.this.pageNumber == WizardViewImpl.this.pageNumberTotal - 1) {
                    return;
                }
                WizardViewImpl.this.selectPage(WizardViewImpl.this.pageNumber + 1);
                WizardViewImpl.this.footer.setNextButtonFocus(false);
            }
        }, new Command(){

            public void execute() {
                WizardViewImpl.this.presenter.close();
            }
        }, new Command(){

            public void execute() {
                WizardViewImpl.this.presenter.complete();
            }
        });
        this.add((Widget)uiBinder.createAndBindUi(this));
        this.add((Widget)this.footer);
    }

    public void init(AbstractWizard presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setPageTitles(List<WizardPage> pages) {
        this.releaseWizardPageTitles();
        this.sideBar.clear();
        this.pageNumberTotal = pages.size();
        for (WizardPage page : pages) {
            WizardPageTitle wpt = this.makeWizardPageTitle(page);
            this.pageTitleWidgets.add(wpt);
            this.sideBar.add((Widget)wpt);
        }
    }

    private void releaseWizardPageTitles() {
        for (WizardPageTitle wpt : this.pageTitleWidgets) {
            this.iocBeanManager.destroyBean((Object)wpt);
        }
        this.pageTitleWidgets.clear();
    }

    private WizardPageTitle makeWizardPageTitle(WizardPage page) {
        IOCBeanDef beanDefinition = this.iocBeanManager.lookupBean(WizardPageTitle.class, new Annotation[0]);
        WizardPageTitle bean = (WizardPageTitle)((Object)beanDefinition.getInstance());
        bean.setContent(page);
        return bean;
    }

    @Override
    public void selectPage(int pageNumber) {
        if (pageNumber < 0 || pageNumber > this.pageNumberTotal - 1) {
            return;
        }
        this.pageNumber = pageNumber;
        for (int i = 0; i < this.pageTitleWidgets.size(); ++i) {
            WizardPageTitle wpt = this.pageTitleWidgets.get(i);
            wpt.setPageSelected(i == pageNumber);
        }
        this.footer.enableNextButton(pageNumber < this.pageNumberTotal - 1);
        this.footer.enablePreviousButton(pageNumber > 0);
        this.presenter.pageSelected(pageNumber);
    }

    @Override
    public void setBodyWidget(Widget w) {
        this.body.setWidget(w);
    }

    @Override
    public void setPreferredHeight(int height) {
        this.sideBarContainer.setHeight(height + "px");
        this.bodyContainer.setHeight(height + "px");
    }

    @Override
    public void setPreferredWidth(int width) {
        this.bodyContainer.setWidth(width + "px");
        this.setWidth(width + 230);
    }

    @Override
    public void setPageCompletionState(int pageIndex, boolean isComplete) {
        WizardPageTitle wpt = this.pageTitleWidgets.get(pageIndex);
        wpt.setComplete(isComplete);
    }

    @Override
    public void setCompletionStatus(boolean isComplete) {
        this.footer.enableFinishButton(isComplete);
    }

    @Override
    public void show() {
        super.show();
        this.centerHorizontally((Element)this.getElement());
    }

    private native void centerHorizontally(Element var1);

    static interface WizardActivityViewImplBinder
    extends UiBinder<Widget, WizardViewImpl> {
    }
}

