/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.core.client.tree;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;
import org.gwtbootstrap3.client.ui.Icon;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.widgets.core.client.resources.TreeNavigatorResources;
import org.uberfire.ext.widgets.core.client.tree.Tree;

public class TreeItem
extends Composite {
    private final Type type;
    private Tree tree;
    private Object userObject;
    private TreeItem parent;
    private State state = State.CLOSE;
    private boolean isSelected = false;
    private FlowPanel header;
    private Icon icon;
    private FlowPanel content;
    private FlowPanel item;

    public TreeItem(Type type, String value) {
        this.type = (Type)((Object)PortablePreconditions.checkNotNull((String)"type", (Object)((Object)type)));
        if (type.equals((Object)Type.FOLDER) || type.equals((Object)Type.ROOT)) {
            FlowPanel folder = new FlowPanel();
            folder.setStylePrimaryName(TreeNavigatorResources.INSTANCE.css().treeFolder());
            folder.getElement().getStyle().setDisplay(Style.Display.BLOCK);
            this.header = (FlowPanel)GWT.create(FlowPanel.class);
            this.icon = new Icon(IconType.FOLDER);
            this.content = new FlowPanel();
            Anchor name = new Anchor();
            this.header.setStylePrimaryName(TreeNavigatorResources.INSTANCE.css().treeFolderHeader());
            folder.add((Widget)this.header);
            this.header.add((Widget)this.icon);
            FlowPanel folderName = new FlowPanel();
            folderName.setStylePrimaryName(TreeNavigatorResources.INSTANCE.css().treeFolderName());
            this.header.add((Widget)folderName);
            name.setText(value);
            folderName.add((Widget)name);
            this.header.addDomHandler((EventHandler)new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (!TreeItem.this.isSelected) {
                        TreeItem.this.updateSelected();
                    }
                    if (TreeItem.this.state.equals((Object)State.CLOSE)) {
                        TreeItem.this.setState(State.OPEN, true);
                    } else {
                        TreeItem.this.setState(State.CLOSE, true);
                    }
                }
            }, ClickEvent.getType());
            this.content.setStylePrimaryName(TreeNavigatorResources.INSTANCE.css().treeFolderContent());
            this.content.getElement().getStyle().setDisplay(Style.Display.NONE);
            folder.add((Widget)this.content);
            this.initWidget((Widget)folder);
        } else if (type.equals((Object)Type.ITEM)) {
            this.item = (FlowPanel)GWT.create(FlowPanel.class);
            this.item.setStylePrimaryName(TreeNavigatorResources.INSTANCE.css().treeItem());
            this.icon = new Icon(IconType.FILE_O);
            FlowPanel itemName = new FlowPanel();
            Anchor name = new Anchor();
            this.item.add((Widget)this.icon);
            itemName.setStylePrimaryName(TreeNavigatorResources.INSTANCE.css().treeItemName());
            this.item.add((Widget)itemName);
            name.setText(value);
            itemName.add((Widget)name);
            this.item.addDomHandler((EventHandler)new ClickHandler(){

                public void onClick(ClickEvent event) {
                    TreeItem.this.tree.onSelection(TreeItem.this, true);
                }
            }, ClickEvent.getType());
            this.initWidget((Widget)this.item);
        } else {
            FlowPanel loader = new FlowPanel();
            SimplePanel loading = new SimplePanel();
            loading.getElement().setInnerText(value);
            loader.add((Widget)loading);
            this.initWidget((Widget)loader);
        }
    }

    private void updateSelected() {
        this.tree.onSelection(this, true);
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.setState(state, false, true);
    }

    public void setState(State state, boolean fireEvents) {
        this.setState(state, false, fireEvents);
    }

    public void setState(State state, boolean propagateParent, boolean fireEvents) {
        if (this.notFolder()) {
            return;
        }
        if (!this.state.equals((Object)state)) {
            this.state = state;
            this.updateState(state);
            if (fireEvents && this.tree != null) {
                this.tree.fireStateChanged(this, state);
            }
        }
        if (propagateParent && this.parent != null) {
            this.parent.setState(state, true, false);
        }
    }

    private boolean notFolder() {
        return !this.type.equals((Object)Type.FOLDER);
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public Type getType() {
        return this.type;
    }

    public TreeItem addItem(Type type, String value) {
        if (this.notFolder()) {
            return null;
        }
        TreeItem child = this.makeChild(type, value);
        this.content.add((Widget)child);
        child.setTree(this.tree);
        child.setParent(this);
        return child;
    }

    protected TreeItem makeChild(Type type, String value) {
        return new TreeItem(type, value);
    }

    public void removeItems() {
        this.content.clear();
    }

    public int getChildCount() {
        return this.content.getWidgetCount();
    }

    public TreeItem getChild(int i) {
        if (i + 1 > this.content.getWidgetCount()) {
            return null;
        }
        return (TreeItem)this.content.getWidget(i);
    }

    public Iterable<TreeItem> getChildren() {
        return new Iterable<TreeItem>(){

            @Override
            public Iterator<TreeItem> iterator() {
                return new TreeItemIterator((ComplexPanel)TreeItem.this.content);
            }
        };
    }

    void setTree(Tree tree) {
        this.tree = tree;
    }

    void setParent(TreeItem parent) {
        this.parent = parent;
    }

    void updateState(State state) {
        if (this.tree == null) {
            return;
        }
        switch (state) {
            case OPEN: {
                this.content.getElement().getStyle().setDisplay(Style.Display.BLOCK);
                this.icon.setType(IconType.FOLDER_OPEN);
                break;
            }
            case CLOSE: {
                this.icon.setType(IconType.FOLDER);
                this.content.getElement().getStyle().setDisplay(Style.Display.NONE);
            }
        }
    }

    public void remove() {
        if (this.parent != null) {
            this.parent.removeItem(this);
        } else if (this.tree != null) {
            this.tree.removeItem(this);
        }
    }

    private void removeItem(TreeItem treeItem) {
        this.content.remove((Widget)treeItem);
    }

    public String getText() {
        return this.getElement().getInnerText();
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    void setSelected(boolean selected) {
        this.isSelected = selected;
        if (selected) {
            if (this.header != null) {
                this.header.addStyleName(TreeNavigatorResources.INSTANCE.css().treeSelected());
            } else {
                this.item.addStyleName(TreeNavigatorResources.INSTANCE.css().treeSelected());
            }
        } else if (this.header != null) {
            this.header.removeStyleName(TreeNavigatorResources.INSTANCE.css().treeSelected());
        } else {
            this.item.removeStyleName(TreeNavigatorResources.INSTANCE.css().treeSelected());
        }
    }

    public boolean isEmpty() {
        return this.content.getWidgetCount() == 0;
    }

    protected static class TreeItemIterator
    implements Iterator<TreeItem> {
        private final ComplexPanel container;
        private int index = 0;

        TreeItemIterator(ComplexPanel container) {
            this.container = container;
        }

        @Override
        public boolean hasNext() {
            if (this.container == null) {
                return false;
            }
            return this.index < this.container.getWidgetCount();
        }

        @Override
        public TreeItem next() {
            return (TreeItem)this.container.getWidget(this.index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static enum State {
        NONE,
        OPEN,
        CLOSE;

    }

    public static enum Type {
        ROOT,
        FOLDER,
        ITEM,
        LOADING;

    }
}

