/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.core.client.tree;

import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasCloseHandlers;
import com.google.gwt.event.logical.shared.HasOpenHandlers;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;
import org.uberfire.ext.widgets.core.client.resources.TreeNavigatorResources;
import org.uberfire.ext.widgets.core.client.tree.TreeItem;

public class Tree
extends Composite
implements HasSelectionHandlers<TreeItem>,
HasOpenHandlers<TreeItem>,
HasCloseHandlers<TreeItem> {
    final FlowPanel container = new FlowPanel();
    private TreeItem curSelection = null;

    public Tree() {
        this.initWidget((Widget)this.container);
        this.container.setStylePrimaryName(TreeNavigatorResources.INSTANCE.css().tree());
    }

    public HandlerRegistration addOpenHandler(OpenHandler<TreeItem> handler) {
        return this.addHandler((EventHandler)handler, OpenEvent.getType());
    }

    public HandlerRegistration addCloseHandler(CloseHandler<TreeItem> handler) {
        return this.addHandler((EventHandler)handler, CloseEvent.getType());
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<TreeItem> handler) {
        return this.addHandler((EventHandler)handler, SelectionEvent.getType());
    }

    public void clear() {
        this.container.clear();
    }

    void fireStateChanged(TreeItem item, TreeItem.State state) {
        if (state.equals((Object)TreeItem.State.OPEN)) {
            OpenEvent.fire((HasOpenHandlers)this, (Object)((Object)item));
        } else {
            CloseEvent.fire((HasCloseHandlers)this, (Object)((Object)item));
        }
        this.onSelection(item, true);
    }

    public void setSelectedItem(TreeItem item, boolean fireEvents) {
        this.onSelection(item, fireEvents);
    }

    public TreeItem getSelectedItem() {
        return this.curSelection;
    }

    public void setSelectedItem(TreeItem item) {
        this.onSelection(item, true);
    }

    void onSelection(TreeItem item, boolean fireEvents) {
        if (this.curSelection != null) {
            this.curSelection.setSelected(false);
        }
        this.curSelection = item;
        if (this.curSelection != null) {
            this.curSelection.setSelected(true);
            if (fireEvents) {
                SelectionEvent.fire((HasSelectionHandlers)this, (Object)((Object)this.curSelection));
            }
        }
    }

    public TreeItem addItem(TreeItem.Type type, String value) {
        TreeItem item = new TreeItem(type, value);
        return this.addItem(item);
    }

    public TreeItem addItem(TreeItem item) {
        this.container.add((Widget)item);
        item.setTree(this);
        return item;
    }

    public void removeItem(TreeItem treeItem) {
        this.container.remove((Widget)treeItem);
    }

    public Iterable<TreeItem> getItems() {
        return new Iterable<TreeItem>(){

            @Override
            public Iterator<TreeItem> iterator() {
                return new TreeItem.TreeItemIterator((ComplexPanel)Tree.this.container);
            }
        };
    }

    public boolean isEmpty() {
        return this.container.getWidgetCount() == 0;
    }
}

