/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.core.client.tree;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;
import java.util.function.Supplier;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.widgets.core.client.resources.TreeNavigatorResources;
import org.uberfire.ext.widgets.core.client.tree.Tree;

public class TreeItem<I extends TreeItem>
extends Composite {
    private final Type type;
    protected FlowPanel content;
    private Tree<I> tree;
    private Object userObject;
    private I parentItem;
    private State state;
    private String label;
    private String uuid;
    private boolean isSelected = false;
    private FlowPanel header;
    private IsWidget icon;
    private FlowPanel item;

    public TreeItem(Type type, String value, String label, IsWidget icon) {
        this(type, value, label, icon, FlowPanel::new);
    }

    TreeItem(Type type, String value, String label, IsWidget icon, Supplier<FlowPanel> contentProvider) {
        this.label = label;
        this.uuid = value;
        this.type = (Type)((Object)PortablePreconditions.checkNotNull((String)"type", (Object)((Object)type)));
        if (type.equals((Object)Type.CONTAINER) || type.equals((Object)Type.ROOT)) {
            FlowPanel folder = contentProvider.get();
            folder.setStylePrimaryName(TreeNavigatorResources.INSTANCE.css().treeFolder());
            folder.getElement().getStyle().setDisplay(Style.Display.BLOCK);
            this.state = State.CLOSE;
            this.header = (FlowPanel)GWT.create(FlowPanel.class);
            this.icon = icon;
            this.content = contentProvider.get();
            Anchor name = new Anchor();
            this.header.setStylePrimaryName(TreeNavigatorResources.INSTANCE.css().treeFolderHeader());
            folder.add((Widget)this.header);
            this.header.add(icon);
            FlowPanel folderName = new FlowPanel();
            folderName.setStylePrimaryName(TreeNavigatorResources.INSTANCE.css().treeFolderName());
            this.header.add((Widget)folderName);
            name.setText(label);
            name.setTitle(value);
            folderName.add((Widget)name);
            this.header.addDomHandler((EventHandler)new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (!TreeItem.this.isSelected) {
                        TreeItem.this.updateSelected();
                    }
                    if (TreeItem.this.state.equals((Object)State.CLOSE)) {
                        TreeItem.this.setState(State.OPEN, true);
                    } else {
                        TreeItem.this.setState(State.CLOSE, true);
                    }
                }
            }, ClickEvent.getType());
            this.content.setStylePrimaryName(TreeNavigatorResources.INSTANCE.css().treeFolderContent());
            this.content.getElement().getStyle().setDisplay(Style.Display.NONE);
            folder.add((Widget)this.content);
            this.initWidget((Widget)folder);
        } else if (type.equals((Object)Type.ITEM)) {
            this.state = State.NONE;
            this.item = contentProvider.get();
            this.item.setStylePrimaryName(TreeNavigatorResources.INSTANCE.css().treeItem());
            this.icon = icon;
            FlowPanel itemName = new FlowPanel();
            Anchor name = new Anchor();
            this.item.add(icon);
            itemName.setStylePrimaryName(TreeNavigatorResources.INSTANCE.css().treeItemName());
            this.item.add((Widget)itemName);
            name.setText(label);
            name.setTitle(value);
            itemName.add((Widget)name);
            this.item.addDomHandler((EventHandler)new ClickHandler(){

                public void onClick(ClickEvent event) {
                    TreeItem.this.tree.onSelection(TreeItem.this, true);
                }
            }, ClickEvent.getType());
            this.initWidget((Widget)this.item);
        } else {
            FlowPanel loader = new FlowPanel();
            SimplePanel loading = new SimplePanel();
            loading.getElement().setInnerText(value);
            loader.add((Widget)loading);
            this.initWidget((Widget)loader);
        }
    }

    public I getItemByUuid(String uuid) {
        if (this.getUuid().equals(uuid)) {
            return (I)((Object)this);
        }
        TreeItem[] selectedItem = new TreeItem[1];
        this.getChildren().forEach(c -> {
            if (selectedItem[0] == null) {
                selectedItem[0] = c.getItemByUuid(uuid);
            }
        });
        return (I)((Object)selectedItem[0]);
    }

    private void updateSelected() {
        this.tree.onSelection((I)((Object)this), true);
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.setState(state, false, true);
    }

    public void setState(State state, boolean fireEvents) {
        this.setState(state, false, fireEvents);
    }

    public void setState(State state, boolean propagateParent, boolean fireEvents) {
        if (this.notFolder()) {
            return;
        }
        if (!this.state.equals((Object)state)) {
            this.state = state;
            this.updateState(state);
            if (fireEvents && this.tree != null) {
                this.tree.fireStateChanged((I)((Object)this), state);
            }
        }
        if (propagateParent && this.parentItem != null) {
            ((TreeItem)((Object)this.parentItem)).setState(state, true, false);
        }
    }

    private boolean notFolder() {
        return !this.type.equals((Object)Type.CONTAINER);
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public Type getType() {
        return this.type;
    }

    public I addItem(I item) {
        this.checkContainerType();
        this.content.add(item);
        item.setTree(this.tree);
        item.setParentItem((TreeItem)this);
        return (I)((Object)item);
    }

    private void checkContainerType() {
        if (null == this.content) {
            throw new IllegalStateException("This tree item instance is not a container.");
        }
    }

    public I addItem(Type type, String value, String label, IsWidget icon) {
        I child = this.makeChild(type, value, label, icon);
        this.addItem(child);
        return child;
    }

    private I makeChild(Type type, String value, String label, IsWidget icon) {
        return (I)((Object)new TreeItem<I>(type, value, label, icon));
    }

    public void removeItems() {
        this.checkContainerType();
        this.content.clear();
    }

    public int getChildCount() {
        return null != this.content ? this.content.getWidgetCount() : 0;
    }

    public I getChild(int i) {
        this.checkContainerType();
        if (i + 1 > this.content.getWidgetCount()) {
            return null;
        }
        return (I)((Object)((TreeItem)this.content.getWidget(i)));
    }

    public Iterable<I> getChildren() {
        return () -> new TreeItemIterator((ComplexPanel)this.content);
    }

    void setTree(Tree<I> tree) {
        this.tree = tree;
    }

    void updateState(State state) {
        if (this.tree == null) {
            return;
        }
        switch (state) {
            case OPEN: {
                this.onOpenState();
                break;
            }
            case CLOSE: {
                this.onCloseState();
            }
        }
    }

    protected void onOpenState() {
        this.content.getElement().getStyle().setDisplay(Style.Display.BLOCK);
    }

    protected void onCloseState() {
        this.content.getElement().getStyle().setDisplay(Style.Display.NONE);
    }

    public void remove() {
        if (this.parentItem != null) {
            this.parentItem.removeItem((TreeItem)this);
        } else if (this.tree != null) {
            this.tree.removeItem((I)((Object)this));
        }
    }

    public void removeItem(I treeItem) {
        this.checkContainerType();
        this.content.remove(treeItem);
    }

    public String getText() {
        return this.getElement().getInnerText();
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    void setSelected(boolean selected) {
        this.isSelected = selected;
        if (selected) {
            if (this.header != null) {
                this.header.addStyleName(TreeNavigatorResources.INSTANCE.css().treeSelected());
            } else {
                this.item.addStyleName(TreeNavigatorResources.INSTANCE.css().treeSelected());
            }
        } else if (this.header != null) {
            this.header.removeStyleName(TreeNavigatorResources.INSTANCE.css().treeSelected());
        } else {
            this.item.removeStyleName(TreeNavigatorResources.INSTANCE.css().treeSelected());
        }
    }

    public TreeItem getParentItem() {
        return this.parentItem;
    }

    void setParentItem(I parent) {
        this.parentItem = parent;
    }

    public boolean isEmpty() {
        return null == this.content || this.content.getWidgetCount() == 0;
    }

    IsWidget getIconWidget() {
        return this.icon;
    }

    FlowPanel getContent() {
        return this.content;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TreeItem)) {
            return false;
        }
        TreeItem that = (TreeItem)((Object)other);
        return this.getUuid().equals(that.getUuid());
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    protected static class TreeItemIterator<T>
    implements Iterator<T> {
        private final ComplexPanel container;
        private int index = 0;

        TreeItemIterator(ComplexPanel container) {
            this.container = container;
        }

        @Override
        public boolean hasNext() {
            if (this.container == null) {
                return false;
            }
            return this.index < this.container.getWidgetCount();
        }

        @Override
        public T next() {
            return (T)this.container.getWidget(this.index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static enum State {
        NONE,
        OPEN,
        CLOSE;

    }

    public static enum Type {
        ROOT,
        CONTAINER,
        ITEM;

    }
}

