/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.core.client.wizards;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Widget;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Column;
import org.gwtbootstrap3.client.ui.NavPills;
import org.gwtbootstrap3.client.ui.base.modal.ModalDialog;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.core.client.wizards.AbstractWizard;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageTitle;
import org.uberfire.ext.widgets.core.client.wizards.WizardPopupFooter;
import org.uberfire.ext.widgets.core.client.wizards.WizardView;

@Dependent
public class WizardViewImpl
extends BaseModal
implements WizardView {
    private static WizardActivityViewImplBinder uiBinder = (WizardActivityViewImplBinder)GWT.create(WizardActivityViewImplBinder.class);
    @UiField
    protected NavPills sideBar;
    @UiField
    protected Column body;
    protected WizardPopupFooter footer;
    @Inject
    protected SyncBeanManager iocBeanManager;
    protected List<WizardPageTitle> pageTitleWidgets = new ArrayList<WizardPageTitle>();
    private int pageNumber;
    private int pageNumberTotal;
    private AbstractWizard presenter;

    public WizardViewImpl() {
        this.footer = new WizardPopupFooter(new Command(){

            public void execute() {
                if (WizardViewImpl.this.pageNumber == 0) {
                    return;
                }
                WizardViewImpl.this.selectPage(WizardViewImpl.this.pageNumber - 1);
                WizardViewImpl.this.footer.setPreviousButtonFocus(false);
            }
        }, new Command(){

            public void execute() {
                if (WizardViewImpl.this.pageNumber == WizardViewImpl.this.pageNumberTotal - 1) {
                    return;
                }
                WizardViewImpl.this.selectPage(WizardViewImpl.this.pageNumber + 1);
                WizardViewImpl.this.footer.setNextButtonFocus(false);
            }
        }, new Command(){

            public void execute() {
                WizardViewImpl.this.presenter.close();
            }
        }, new Command(){

            public void execute() {
                WizardViewImpl.this.presenter.complete();
            }
        });
        this.setBody((Widget)uiBinder.createAndBindUi(this));
        this.add((Widget)this.footer);
    }

    protected void onUnload() {
        this.parentOnUnload();
        this.getPresenter().close();
    }

    void parentOnUnload() {
        super.onUnload();
    }

    AbstractWizard getPresenter() {
        return this.presenter;
    }

    public void init(AbstractWizard presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setPageTitles(List<WizardPage> pages) {
        this.releaseWizardPageTitles();
        this.sideBar.clear();
        this.pageNumberTotal = pages.size();
        for (WizardPage page : pages) {
            WizardPageTitle wpt = this.makeWizardPageTitle(page);
            this.pageTitleWidgets.add(wpt);
            this.sideBar.add((Widget)wpt);
        }
    }

    private void releaseWizardPageTitles() {
        for (WizardPageTitle wpt : this.pageTitleWidgets) {
            this.iocBeanManager.destroyBean((Object)wpt);
        }
        this.pageTitleWidgets.clear();
    }

    protected WizardPageTitle makeWizardPageTitle(WizardPage page) {
        SyncBeanDef beanDefinition = this.iocBeanManager.lookupBean(WizardPageTitle.class, new Annotation[0]);
        WizardPageTitle bean = (WizardPageTitle)((Object)beanDefinition.getInstance());
        bean.setContent(page);
        return bean;
    }

    @Override
    public void selectPage(int pageNumber) {
        if (pageNumber < 0 || pageNumber > this.pageNumberTotal - 1) {
            return;
        }
        this.pageNumber = pageNumber;
        for (int i = 0; i < this.pageTitleWidgets.size(); ++i) {
            WizardPageTitle wpt = this.pageTitleWidgets.get(i);
            wpt.setPageSelected(i == pageNumber);
        }
        this.footer.enableNextButton(pageNumber < this.pageNumberTotal - 1);
        this.footer.enablePreviousButton(pageNumber > 0);
        this.presenter.pageSelected(pageNumber);
    }

    @Override
    public void setBodyWidget(Widget w) {
        this.body.clear();
        this.body.add(w);
    }

    @Override
    public void setPreferredHeight(int height) {
        if (this.getWidgetCount() == 1 && this.getWidget(0) instanceof ModalDialog) {
            this.getWidget(0).setHeight(height + "px");
        }
    }

    @Override
    public void setPreferredWidth(int width) {
        this.setWidth(width + "px");
    }

    @Override
    public void setPageCompletionState(int pageIndex, boolean isComplete) {
        WizardPageTitle wpt = this.pageTitleWidgets.get(pageIndex);
        wpt.setComplete(isComplete);
    }

    @Override
    public void setCompletionStatus(boolean isComplete) {
        this.footer.enableFinishButton(isComplete);
    }

    @Override
    public void show() {
        super.show();
    }

    @Override
    public void hide() {
        super.hide();
        this.releaseWizardPageTitles();
    }

    static interface WizardActivityViewImplBinder
    extends UiBinder<Widget, WizardViewImpl> {
    }
}

