/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.table.client;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CheckboxCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.TextHeader;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.gwtbootstrap3.client.ui.gwt.DataGrid;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.table.client.ColumnMeta;
import org.uberfire.ext.widgets.table.client.UberfireColumnPicker;

@RunWith(value=GwtMockitoTestRunner.class)
public class UberfireColumnPickerTest {
    @Mock
    protected DataGrid dataGrid;
    @InjectMocks
    private UberfireColumnPicker<String> uberfireColumnPicker;
    @GwtMock
    VerticalPanel popupContent;
    private ColumnMeta columnMetaTextCell1;
    private ColumnMeta columnMetaTextCell2;
    private ColumnMeta columnMetaCheckBoxCell;

    @Before
    public void setup() {
        this.columnMetaTextCell1 = this.createColumnTextCell("val1", "col1");
        this.columnMetaTextCell2 = this.createColumnTextCell("val2", "col2");
        this.columnMetaCheckBoxCell = this.createColumnCheckboxCell("columnMetaCheckBoxCell");
        this.uberfireColumnPicker.addColumn(this.columnMetaCheckBoxCell);
        this.uberfireColumnPicker.addColumn(this.columnMetaTextCell1);
        this.uberfireColumnPicker.addColumn(this.columnMetaTextCell2);
    }

    @Test
    public void testAddThisColumnToPopup() {
        Assert.assertTrue((boolean)this.uberfireColumnPicker.addThisColumnToPopup(this.columnMetaTextCell1));
        Assert.assertFalse((boolean)this.uberfireColumnPicker.addThisColumnToPopup(this.columnMetaCheckBoxCell));
    }

    @Test
    public void testOnlyAddHeaderStringColumnPickerPopup() {
        this.uberfireColumnPicker.showColumnPickerPopup(0, 0);
        ((VerticalPanel)Mockito.verify((Object)this.popupContent, (VerificationMode)Mockito.times((int)2))).add((Widget)Mockito.any(org.gwtbootstrap3.client.ui.gwt.Widget.class));
    }

    private ColumnMeta createColumnTextCell(final String value, String dataStoreName) {
        Column<String, String> testColumn = new Column<String, String>((Cell)new TextCell()){

            public String getValue(String object) {
                return value;
            }
        };
        testColumn.setSortable(true);
        testColumn.setDataStoreName(dataStoreName);
        TextHeader header = new TextHeader(value);
        ColumnMeta columnMeta = new ColumnMeta((Column)testColumn, dataStoreName);
        columnMeta.setHeader((Header)header);
        return columnMeta;
    }

    private ColumnMeta createColumnCheckboxCell(String dataStoreName) {
        CheckboxCell checkboxCell = new CheckboxCell(true, false);
        Column<String, Boolean> checkColumn = new Column<String, Boolean>((Cell)checkboxCell){

            public Boolean getValue(String object) {
                return true;
            }
        };
        Header<Boolean> selectPageHeader = new Header<Boolean>((Cell)checkboxCell){

            public Boolean getValue() {
                return true;
            }
        };
        checkColumn.setSortable(false);
        checkColumn.setDataStoreName(dataStoreName);
        ColumnMeta checkColMeta = new ColumnMeta((Column)checkColumn, "");
        checkColMeta.setHeader((Header)selectPageHeader);
        return checkColMeta;
    }
}

