/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.table.client;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CheckboxCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.TextHeader;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.gwtbootstrap3.client.ui.gwt.DataGrid;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.table.client.ColumnMeta;
import org.uberfire.ext.widgets.table.client.UberfireColumnPicker;

@RunWith(value=GwtMockitoTestRunner.class)
public class UberfireColumnPickerTest {
    @Mock
    protected DataGrid dataGrid;
    @GwtMock
    VerticalPanel popupContent;
    @InjectMocks
    private UberfireColumnPicker<String> uberfireColumnPicker;
    private ColumnMeta columnMetaTextCell1;
    private ColumnMeta columnMetaTextCell2;
    private ColumnMeta columnMetaCheckBoxCell;

    @Before
    public void setup() {
        this.columnMetaTextCell1 = this.createColumnTextCell("val1", "col1");
        this.columnMetaTextCell2 = this.createColumnTextCell("val2", "col2");
        this.columnMetaCheckBoxCell = this.createColumnCheckboxCell("columnMetaCheckBoxCell");
        this.uberfireColumnPicker.addColumn(this.columnMetaCheckBoxCell);
        this.uberfireColumnPicker.addColumn(this.columnMetaTextCell1);
        this.uberfireColumnPicker.addColumn(this.columnMetaTextCell2);
    }

    @Test
    public void testAddThisColumnToPopup() {
        Assert.assertTrue((boolean)this.uberfireColumnPicker.addThisColumnToPopup(this.columnMetaTextCell1));
        Assert.assertFalse((boolean)this.uberfireColumnPicker.addThisColumnToPopup(this.columnMetaCheckBoxCell));
    }

    @Test
    public void testOnlyAddHeaderStringColumnPickerPopup() {
        this.uberfireColumnPicker.showColumnPickerPopup(0, 0);
        ((VerticalPanel)Mockito.verify((Object)this.popupContent, (VerificationMode)Mockito.times((int)2))).add((Widget)Mockito.any(org.gwtbootstrap3.client.ui.gwt.Widget.class));
    }

    private ColumnMeta createColumnMeta(String value, String dataStoreName, boolean isVisible, boolean isVisibleIndex) {
        TextHeader header = new TextHeader(value);
        ColumnMeta columnMeta = new ColumnMeta(this.createColumn(value, dataStoreName), dataStoreName);
        columnMeta.setHeader((Header)header);
        columnMeta.setVisible(isVisible);
        columnMeta.setVisibleIndex(isVisibleIndex);
        return columnMeta;
    }

    private Column createColumn(final String value, String dataStoreName) {
        Column<String, String> testColumn = new Column<String, String>((Cell)new TextCell()){

            public String getValue(String object) {
                return value;
            }
        };
        testColumn.setSortable(true);
        testColumn.setDataStoreName(dataStoreName);
        return testColumn;
    }

    private ColumnMeta createColumnTextCell(String value, String dataStoreName) {
        return this.createColumnMeta(value, dataStoreName, true, true);
    }

    private ColumnMeta createColumnCheckboxCell(String dataStoreName) {
        CheckboxCell checkboxCell = new CheckboxCell(true, false);
        Column<String, Boolean> checkColumn = new Column<String, Boolean>((Cell)checkboxCell){

            public Boolean getValue(String object) {
                return true;
            }
        };
        Header<Boolean> selectPageHeader = new Header<Boolean>((Cell)checkboxCell){

            public Boolean getValue() {
                return true;
            }
        };
        checkColumn.setSortable(false);
        checkColumn.setDataStoreName(dataStoreName);
        ColumnMeta checkColMeta = new ColumnMeta((Column)checkColumn, "");
        checkColMeta.setHeader((Header)selectPageHeader);
        return checkColMeta;
    }

    @Test
    public void testAddColumnBeforeActions() {
        UberfireColumnPicker columnPicker = new UberfireColumnPicker(new DataGrid());
        ColumnMeta name = this.createColumnMeta("Name", "name", true, true);
        ColumnMeta age = this.createColumnMeta("Age", "age", true, true);
        ColumnMeta description = this.createColumnMeta("Description", "description", false, true);
        ColumnMeta actions = this.createColumnMeta("Actions", "actions", true, false);
        ColumnMeta etc = this.createColumnMeta("Etc", "etc", false, true);
        columnPicker.addColumn(name);
        columnPicker.addColumn(age);
        columnPicker.addColumn(description);
        columnPicker.addColumn(actions);
        columnPicker.addColumn(etc);
        Assert.assertEquals((long)3L, (long)columnPicker.getDataGrid().getColumnCount());
        Assert.assertEquals((Object)"name", (Object)columnPicker.getDataGrid().getColumn(0).getDataStoreName());
        Assert.assertEquals((Object)"age", (Object)columnPicker.getDataGrid().getColumn(1).getDataStoreName());
        Assert.assertEquals((Object)"actions", (Object)columnPicker.getDataGrid().getColumn(2).getDataStoreName());
        columnPicker.addColumnOnDataGrid(true, etc);
        Assert.assertEquals((long)4L, (long)columnPicker.getDataGrid().getColumnCount());
        Assert.assertEquals((Object)"etc", (Object)columnPicker.getDataGrid().getColumn(2).getDataStoreName());
        Assert.assertEquals((Object)"actions", (Object)columnPicker.getDataGrid().getColumn(3).getDataStoreName());
        columnPicker.addColumnOnDataGrid(true, description);
        Assert.assertEquals((long)5L, (long)columnPicker.getDataGrid().getColumnCount());
        Assert.assertEquals((Object)"description", (Object)columnPicker.getDataGrid().getColumn(2).getDataStoreName());
        Assert.assertEquals((Object)"etc", (Object)columnPicker.getDataGrid().getColumn(3).getDataStoreName());
        Assert.assertEquals((Object)"actions", (Object)columnPicker.getDataGrid().getColumn(4).getDataStoreName());
    }
}

