/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.table.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.user.cellview.client.RowStyles;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.Range;
import com.google.gwt.view.client.RangeChangeEvent;
import com.google.gwt.view.client.RowCountChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import java.util.List;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Label;
import org.uberfire.client.views.pfly.sys.PatternFlyBootstrapper;
import org.uberfire.ext.widgets.table.client.ColumnChangedHandler;
import org.uberfire.ext.widgets.table.client.ColumnMeta;
import org.uberfire.ext.widgets.table.client.DataGrid;
import org.uberfire.ext.widgets.table.client.ResizableMovableHeader;
import org.uberfire.ext.widgets.table.client.UberfireColumnPicker;
import org.uberfire.ext.widgets.table.client.resources.UFTableResources;

public class UberfireSimpleTable<T>
extends Composite
implements HasData<T> {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    @UiField(provided=true)
    public Button columnPickerButton;
    @UiField(provided=true)
    public DataGrid<T> dataGrid;
    @UiField
    public HorizontalPanel toolbarContainer;
    @UiField
    public HorizontalPanel rightToolbar;
    @UiField
    public FlowPanel rightActionsToolbar;
    @UiField
    public FlowPanel leftToolbar;
    @UiField
    public FlowPanel centerToolbar;
    protected UberfireColumnPicker<T> columnPicker;
    private String emptyTableCaption;

    public UberfireSimpleTable() {
        this.setupDataGrid(null);
        this.setupGridTable();
    }

    public UberfireSimpleTable(ProvidesKey<T> providesKey) {
        this.setupDataGrid(providesKey);
        this.setupGridTable();
    }

    protected static native void addDataGridStyles(JavaScriptObject var0, String var1, String var2);

    protected void setupGridTable() {
        this.setupDataGrid();
        this.setEmptyTableWidget();
        this.setupColumnPicker();
        this.columnPickerButton = this.getColumnPicker().createToggleButton();
        this.initWidget(this.makeWidget());
    }

    protected void setupColumnPicker() {
        this.setColumnPicker(new UberfireColumnPicker<T>(this.dataGrid));
    }

    protected UberfireColumnPicker<T> getColumnPicker() {
        return this.columnPicker;
    }

    protected void setColumnPicker(UberfireColumnPicker<T> columnPicker) {
        this.columnPicker = columnPicker;
    }

    protected void setupDataGrid(ProvidesKey<T> providesKey) {
        this.dataGrid = providesKey != null ? new DataGrid<T>(providesKey) : new DataGrid();
    }

    public void setEmptyTableCaption(String emptyTableCaption) {
        this.emptyTableCaption = emptyTableCaption;
        this.setEmptyTableWidget();
    }

    protected void setupDataGrid() {
        PatternFlyBootstrapper.ensurejQueryIsAvailable();
        this.dataGrid.setSkipRowHoverCheck(false);
        this.dataGrid.setSkipRowHoverStyleUpdate(false);
        this.dataGrid.addStyleName(UFTableResources.INSTANCE.CSS().dataGridMain());
        this.dataGrid.addStyleName(UFTableResources.INSTANCE.CSS().dataGrid());
        this.dataGrid.setRowStyles((row, rowIndex) -> UFTableResources.INSTANCE.CSS().dataGridRow());
        UberfireSimpleTable.addDataGridStyles((JavaScriptObject)this.dataGrid.getElement(), UFTableResources.INSTANCE.CSS().dataGridHeader(), UFTableResources.INSTANCE.CSS().dataGridContent());
    }

    protected void setEmptyTableWidget() {
        String caption = "-----";
        if (!this.emptyCaptionIsDefined()) {
            caption = this.emptyTableCaption;
        }
        this.dataGrid.setEmptyTableWidget((Widget)new Label(caption));
    }

    private boolean emptyCaptionIsDefined() {
        return this.emptyTableCaption == null || this.emptyTableCaption.trim().isEmpty();
    }

    protected Widget makeWidget() {
        return (Widget)uiBinder.createAndBindUi((Object)this);
    }

    public void redraw() {
        this.dataGrid.redraw();
        this.dataGrid.flush();
    }

    public void refresh() {
        this.dataGrid.setVisibleRangeAndClearData(this.dataGrid.getVisibleRange(), true);
    }

    public HandlerRegistration addCellPreviewHandler(CellPreviewEvent.Handler<T> handler) {
        return this.dataGrid.addCellPreviewHandler(handler);
    }

    public HandlerRegistration addRangeChangeHandler(RangeChangeEvent.Handler handler) {
        return this.dataGrid.addRangeChangeHandler(handler);
    }

    public HandlerRegistration addRowCountChangeHandler(RowCountChangeEvent.Handler handler) {
        return this.dataGrid.addRowCountChangeHandler(handler);
    }

    public int getColumnIndex(Column<T, ?> column) {
        return this.dataGrid.getColumnIndex(column);
    }

    public HandlerRegistration addColumnSortHandler(ColumnSortEvent.Handler handler) {
        return this.dataGrid.addColumnSortHandler(handler);
    }

    public int getRowCount() {
        return this.dataGrid.getRowCount();
    }

    public void setRowCount(int count) {
        this.dataGrid.setRowCount(count);
    }

    public Range getVisibleRange() {
        return this.dataGrid.getVisibleRange();
    }

    public void setVisibleRange(Range range) {
        this.dataGrid.setVisibleRange(range);
    }

    public boolean isRowCountExact() {
        return this.dataGrid.isRowCountExact();
    }

    public void setRowCount(int count, boolean isExact) {
        this.dataGrid.setRowCount(count, isExact);
    }

    public void setVisibleRange(int start, int length) {
        this.dataGrid.setVisibleRange(start, length);
    }

    public SelectionModel<? super T> getSelectionModel() {
        return this.dataGrid.getSelectionModel();
    }

    public void setSelectionModel(SelectionModel<? super T> selectionModel) {
        this.dataGrid.setSelectionModel(selectionModel);
    }

    public T getVisibleItem(int indexOnPage) {
        return (T)this.dataGrid.getVisibleItem(indexOnPage);
    }

    public int getVisibleItemCount() {
        return this.dataGrid.getVisibleItemCount();
    }

    public Iterable<T> getVisibleItems() {
        return this.dataGrid.getVisibleItems();
    }

    public void setRowData(int start, List<? extends T> values) {
        this.dataGrid.setRowData(start, values);
        this.redraw();
    }

    public void setRowData(List<? extends T> values) {
        this.dataGrid.setRowData(values);
        this.redraw();
    }

    public void setSelectionModel(SelectionModel<? super T> selectionModel, CellPreviewEvent.Handler<T> selectionEventManager) {
        this.dataGrid.setSelectionModel(selectionModel, selectionEventManager);
    }

    public void setVisibleRangeAndClearData(Range range, boolean forceRangeChangeEvent) {
        this.dataGrid.setVisibleRangeAndClearData(range, forceRangeChangeEvent);
    }

    public void setHeight(String height) {
        this.dataGrid.setHeight(height);
    }

    public void setPixelSize(int width, int height) {
        this.dataGrid.setPixelSize(width, height);
    }

    public void setSize(String width, String height) {
        this.dataGrid.setSize(width, height);
    }

    public void setWidth(String width) {
        this.dataGrid.setWidth(width);
    }

    public void setColumnWidth(Column<T, ?> column, double width, Style.Unit unit) {
        this.dataGrid.setColumnWidth(column, width, unit);
        this.getColumnPicker().adjustColumnWidths();
    }

    public void setToolBarVisible(boolean visible) {
        this.toolbarContainer.setVisible(visible);
    }

    public ColumnSortList getColumnSortList() {
        return this.dataGrid.getColumnSortList();
    }

    public HasWidgets getToolbar() {
        return this.toolbarContainer;
    }

    public HasWidgets getRightToolbar() {
        return this.rightToolbar;
    }

    public HasWidgets getRightActionsToolbar() {
        return this.rightActionsToolbar;
    }

    public HasWidgets getLeftToolbar() {
        return this.leftToolbar;
    }

    public HasWidgets getCenterToolbar() {
        return this.centerToolbar;
    }

    public void setRowStyles(RowStyles<T> styles) {
        this.dataGrid.setRowStyles(styles);
    }

    public void addTableTitle(String tableTitle) {
        this.getLeftToolbar().add((Widget)new HTML("<h4>" + tableTitle + "</h4>"));
    }

    public void setAlwaysShowScrollBars(boolean alwaysShowScrollBars) {
        this.dataGrid.setAlwaysShowScrollBars(alwaysShowScrollBars);
    }

    public void addColumn(Column<T, ?> column, String caption) {
        this.addColumn(column, caption, true);
    }

    public void addColumn(Column<T, ?> column, String caption, boolean visible) {
        ColumnMeta<T> columnMeta = new ColumnMeta<T>(column, caption, visible);
        this.addColumn(columnMeta);
    }

    public void addColumns(List<ColumnMeta<T>> columnMetas) {
        for (ColumnMeta<T> columnMeta : columnMetas) {
            if (columnMeta.getHeader() != null) continue;
            columnMeta.setHeader(this.getColumnHeader(columnMeta.getCaption(), columnMeta.getColumn()));
        }
        this.getColumnPicker().addColumns(columnMetas);
    }

    protected void addColumn(ColumnMeta<T> columnMeta) {
        if (columnMeta.getHeader() == null) {
            columnMeta.setHeader(this.getColumnHeader(columnMeta.getCaption(), columnMeta.getColumn()));
        }
        this.getColumnPicker().addColumn(columnMeta);
    }

    protected ResizableMovableHeader<T> getColumnHeader(String caption, Column column) {
        ResizableMovableHeader header = new ResizableMovableHeader<T>(caption, this.dataGrid, this.columnPicker, column){

            @Override
            protected int getTableBodyHeight() {
                return UberfireSimpleTable.this.dataGrid.getOffsetHeight();
            }
        };
        header.addColumnChangedHandler(new ColumnChangedHandler(){

            @Override
            public void afterColumnChanged() {
                UberfireSimpleTable.this.afterColumnChangedHandler();
            }

            @Override
            public void beforeColumnChanged() {
            }
        });
        return header;
    }

    public void setColumnPickerButtonVisible(boolean show) {
        this.columnPickerButton.setVisible(show);
    }

    protected void afterColumnChangedHandler() {
    }

    static interface Binder
    extends UiBinder<Widget, UberfireSimpleTable> {
    }
}

