/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.bpmn.backend;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.editor.commons.backend.service.SaveAndRenameServiceImpl;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.ext.wires.bpmn.api.model.impl.BpmnEditorContent;
import org.uberfire.ext.wires.bpmn.api.model.impl.nodes.ProcessNode;
import org.uberfire.ext.wires.bpmn.api.service.BpmnService;
import org.uberfire.ext.wires.bpmn.api.service.todo.Metadata;
import org.uberfire.ext.wires.bpmn.api.type.BpmnResourceTypeDefinition;
import org.uberfire.ext.wires.bpmn.backend.BpmnPersistence;
import org.uberfire.ext.wires.bpmn.backend.todo.CommentedOptionFactory;
import org.uberfire.ext.wires.bpmn.backend.todo.ExceptionUtilities;
import org.uberfire.ext.wires.bpmn.backend.todo.MetadataFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;

@Service
@ApplicationScoped
public class BpmnServiceImpl
implements BpmnService {
    @Inject
    protected User identity;
    @Inject
    protected SessionInfo sessionInfo;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private CopyService copyService;
    @Inject
    private DeleteService deleteService;
    @Inject
    private RenameService renameService;
    @Inject
    private BpmnResourceTypeDefinition typeDefinition;
    @Inject
    private SaveAndRenameServiceImpl<ProcessNode, Metadata> saveAndRenameService;
    private FileSystem fileSystem;
    private Path root;

    public org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path context, String fileName, ProcessNode content, String comment) {
        try {
            Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)context).resolve(fileName);
            org.uberfire.backend.vfs.Path newPath = Paths.convert((Path)nioPath);
            if (this.ioService.exists(nioPath)) {
                throw new FileAlreadyExistsException(nioPath.toString());
            }
            this.ioService.write(nioPath, BpmnPersistence.getInstance().marshal(content), new OpenOption[]{CommentedOptionFactory.makeCommentedOption(this.identity, this.sessionInfo, comment)});
            return newPath;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException(e);
        }
    }

    public BpmnEditorContent loadContent(org.uberfire.backend.vfs.Path path) {
        try {
            ProcessNode graph = this.load(path);
            BpmnEditorContent content = new BpmnEditorContent(graph);
            return content;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException(e);
        }
    }

    public ProcessNode load(org.uberfire.backend.vfs.Path path) {
        try {
            String content = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)path));
            return BpmnPersistence.getInstance().unmarshal(content);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException(e);
        }
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path path, ProcessNode content, Metadata metadata, String comment) {
        try {
            this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)path), BpmnPersistence.getInstance().marshal(content), MetadataFactory.makeMetadata(metadata), new OpenOption[]{CommentedOptionFactory.makeCommentedOption(this.identity, this.sessionInfo, comment)});
            return path;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException(e);
        }
    }

    public void delete(org.uberfire.backend.vfs.Path path, String comment) {
        try {
            this.deleteService.delete(path, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException(e);
        }
    }

    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.renameService.rename(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException(e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.copyService.copy(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException(e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, org.uberfire.backend.vfs.Path targetDirectory, String comment) {
        throw new UnsupportedOperationException("A bpmn resource cannot be copied to another directory.");
    }

    @PostConstruct
    public void setup() {
        try {
            this.fileSystem = this.ioService.newFileSystem(URI.create("default://bpmn"), (Map)new HashMap<String, Object>(){
                {
                    this.put("init", Boolean.TRUE);
                    this.put("internal", Boolean.TRUE);
                }
            });
        }
        catch (FileSystemAlreadyExistsException e) {
            this.fileSystem = this.ioService.getFileSystem(URI.create("default://bpmn"));
        }
        this.root = (Path)this.fileSystem.getRootDirectories().iterator().next();
        this.ioService.write(this.root.resolve("file1.bpmn"), BpmnPersistence.getInstance().marshal(new ProcessNode()), new OpenOption[0]);
        this.saveAndRenameService.init((SupportsSaveAndRename)this);
    }

    public List<org.uberfire.backend.vfs.Path> listFiles() {
        DirectoryStream stream = this.ioService.newDirectoryStream(this.root, (DirectoryStream.Filter)new DirectoryStream.Filter<Path>(){

            public boolean accept(Path entry) throws IOException {
                return BpmnServiceImpl.this.typeDefinition.accept(Paths.convert((Path)entry));
            }
        });
        ArrayList<org.uberfire.backend.vfs.Path> files = new ArrayList<org.uberfire.backend.vfs.Path>();
        Iterator itr = stream.iterator();
        while (itr.hasNext()) {
            files.add(Paths.convert((Path)((Path)itr.next())));
        }
        return files;
    }

    public org.uberfire.backend.vfs.Path saveAndRename(org.uberfire.backend.vfs.Path path, String newFileName, Metadata metadata, ProcessNode content, String comment) {
        return this.saveAndRenameService.saveAndRename(path, newFileName, (Object)metadata, (Object)content, comment);
    }
}

