/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.bpmn.client.explorer;

import com.github.gwtbootstrap.client.ui.ButtonCell;
import com.github.gwtbootstrap.client.ui.CellTable;
import com.github.gwtbootstrap.client.ui.Label;
import com.github.gwtbootstrap.client.ui.constants.ButtonType;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.github.gwtbootstrap.client.ui.resources.ButtonSize;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.cellview.client.TextHeader;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.wires.bpmn.client.explorer.BpmnExplorerPresenter;
import org.uberfire.ext.wires.bpmn.client.explorer.BpmnExplorerView;
import org.uberfire.ext.wires.bpmn.client.resources.i18n.BpmnEditorConstants;

@Dependent
public class BpmnExplorerViewImpl
extends Composite
implements BpmnExplorerView {
    private static final ViewBinder uiBinder = (ViewBinder)GWT.create(ViewBinder.class);
    @UiField(provided=true)
    CellTable<Path> table = new CellTable();
    private ListDataProvider<Path> dataProvider = new ListDataProvider();
    private BpmnExplorerPresenter presenter;

    @PostConstruct
    public void init() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
    }

    public void init(BpmnExplorerPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setContent(List<Path> files) {
        this.table.setStriped(true);
        this.table.setCondensed(true);
        this.table.setBordered(true);
        this.table.setEmptyTableWidget((Widget)new Label(BpmnEditorConstants.INSTANCE.bpmnExplorerNoFilesFound()));
        TextColumn<Path> urlColumn = new TextColumn<Path>(){

            public String getValue(Path file) {
                return file.toURI();
            }
        };
        ButtonCell openButton = new ButtonCell(ButtonSize.SMALL);
        openButton.setType(ButtonType.PRIMARY);
        openButton.setIcon(IconType.EDIT);
        Column<Path, String> openColumn = new Column<Path, String>((Cell)openButton){

            public String getValue(Path global) {
                return BpmnEditorConstants.INSTANCE.bpmnExplorerNoFilesOpen();
            }
        };
        openColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<Path, String>(){

            public void update(int index, Path file, String value) {
                BpmnExplorerViewImpl.this.presenter.openFile(file);
            }
        });
        this.table.addColumn((Column)urlColumn, (Header)new TextHeader(BpmnEditorConstants.INSTANCE.bpmnExplorerFileUrl()));
        this.table.addColumn((Column)openColumn);
        this.dataProvider.addDataDisplay(this.table);
        this.dataProvider.setList(files);
    }

    static interface ViewBinder
    extends UiBinder<Widget, BpmnExplorerViewImpl> {
    }
}

