/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.bpmn.client.commands.impl;

import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.wires.bpmn.api.model.BpmnGraph;
import org.uberfire.ext.wires.bpmn.api.model.BpmnGraphNode;
import org.uberfire.ext.wires.bpmn.client.commands.Command;
import org.uberfire.ext.wires.bpmn.client.commands.ResultType;
import org.uberfire.ext.wires.bpmn.client.commands.Results;
import org.uberfire.ext.wires.bpmn.client.commands.impl.AddGraphNodeCommand;
import org.uberfire.ext.wires.bpmn.client.commands.impl.DefaultResultImpl;
import org.uberfire.ext.wires.bpmn.client.commands.impl.DefaultResultsImpl;
import org.uberfire.ext.wires.bpmn.client.rules.RuleManager;

public class DeleteGraphNodeCommand
implements Command {
    private BpmnGraph target;
    private BpmnGraphNode candidate;

    public DeleteGraphNodeCommand(BpmnGraph target, BpmnGraphNode candidate) {
        this.target = (BpmnGraph)PortablePreconditions.checkNotNull((String)"target", (Object)target);
        this.candidate = (BpmnGraphNode)PortablePreconditions.checkNotNull((String)"candidate", (Object)candidate);
    }

    @Override
    public Results apply(RuleManager ruleManager) {
        DefaultResultsImpl results = new DefaultResultsImpl();
        boolean isNodeInGraph = false;
        for (BpmnGraphNode node : this.target) {
            if (!node.equals(this.candidate)) continue;
            isNodeInGraph = true;
            break;
        }
        if (isNodeInGraph) {
            results.getMessages().addAll(ruleManager.checkCardinality(this.target, this.candidate, RuleManager.Operation.DELETE).getMessages());
            if (!results.contains(ResultType.ERROR)) {
                this.target.removeNode(this.candidate.getId());
            }
        } else {
            results.addMessage(new DefaultResultImpl(ResultType.WARNING, "GraphNode was not present in Graph and hence was not deleted."));
        }
        return results;
    }

    @Override
    public Results undo(RuleManager ruleManager) {
        AddGraphNodeCommand undoCommand = new AddGraphNodeCommand(this.target, this.candidate);
        return undoCommand.apply(ruleManager);
    }
}

