/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.bpmn.client.commands.impl;

import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.wires.bpmn.api.model.BpmnEdge;
import org.uberfire.ext.wires.bpmn.api.model.BpmnGraphNode;
import org.uberfire.ext.wires.bpmn.client.commands.Command;
import org.uberfire.ext.wires.bpmn.client.commands.ResultType;
import org.uberfire.ext.wires.bpmn.client.commands.Results;
import org.uberfire.ext.wires.bpmn.client.commands.impl.DefaultResultsImpl;
import org.uberfire.ext.wires.bpmn.client.commands.impl.DeleteEdgeCommand;
import org.uberfire.ext.wires.bpmn.client.rules.RuleManager;

public class AddEdgeCommand
implements Command {
    private BpmnGraphNode outgoingNode;
    private BpmnGraphNode incomingNode;
    private BpmnEdge edge;

    public AddEdgeCommand(BpmnGraphNode outgoingNode, BpmnGraphNode incomingNode, BpmnEdge edge) {
        this.outgoingNode = (BpmnGraphNode)PortablePreconditions.checkNotNull((String)"outgoingNode", (Object)outgoingNode);
        this.incomingNode = (BpmnGraphNode)PortablePreconditions.checkNotNull((String)"incomingNode", (Object)incomingNode);
        this.edge = (BpmnEdge)PortablePreconditions.checkNotNull((String)"edge", (Object)edge);
    }

    @Override
    public Results apply(RuleManager ruleManager) {
        DefaultResultsImpl results = new DefaultResultsImpl();
        results.getMessages().addAll(ruleManager.checkConnectionRules(this.outgoingNode, this.incomingNode, this.edge).getMessages());
        results.getMessages().addAll(ruleManager.checkCardinality(this.outgoingNode, this.incomingNode, this.edge, RuleManager.Operation.ADD).getMessages());
        if (!results.contains(ResultType.ERROR)) {
            this.outgoingNode.getOutEdges().add(this.edge);
            this.incomingNode.getInEdges().add(this.edge);
        }
        return results;
    }

    @Override
    public Results undo(RuleManager ruleManager) {
        DeleteEdgeCommand undoCommand = new DeleteEdgeCommand(this.outgoingNode, this.incomingNode, this.edge);
        return undoCommand.apply(ruleManager);
    }
}

