/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.bpmn.client.commands.impl;

import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.ext.wires.bpmn.api.model.BpmnGraph;
import org.uberfire.ext.wires.bpmn.api.model.BpmnGraphNode;
import org.uberfire.ext.wires.bpmn.beliefs.graph.GraphNode;
import org.uberfire.ext.wires.bpmn.client.commands.Command;
import org.uberfire.ext.wires.bpmn.client.commands.ResultType;
import org.uberfire.ext.wires.bpmn.client.commands.Results;
import org.uberfire.ext.wires.bpmn.client.commands.impl.DefaultResultsImpl;
import org.uberfire.ext.wires.bpmn.client.commands.impl.DeleteGraphNodeCommand;
import org.uberfire.ext.wires.bpmn.client.rules.RuleManager;

public class AddGraphNodeCommand
implements Command {
    private BpmnGraph target;
    private BpmnGraphNode candidate;

    public AddGraphNodeCommand(BpmnGraph target, BpmnGraphNode candidate) {
        this.target = (BpmnGraph)PortablePreconditions.checkNotNull((String)"target", (Object)target);
        this.candidate = (BpmnGraphNode)PortablePreconditions.checkNotNull((String)"candidate", (Object)candidate);
    }

    @Override
    public Results apply(RuleManager ruleManager) {
        DefaultResultsImpl results = new DefaultResultsImpl();
        results.getMessages().addAll(ruleManager.checkContainment(this.target, this.candidate).getMessages());
        results.getMessages().addAll(ruleManager.checkCardinality(this.target, this.candidate, RuleManager.Operation.ADD).getMessages());
        if (!results.contains(ResultType.ERROR)) {
            this.target.addNode((GraphNode)this.candidate);
        }
        return results;
    }

    @Override
    public Results undo(RuleManager ruleManager) {
        DeleteGraphNodeCommand undoCommand = new DeleteGraphNodeCommand(this.target, this.candidate);
        return undoCommand.apply(ruleManager);
    }
}

