/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.api.shapes;

import com.emitrom.lienzo.client.core.event.NodeDragMoveEvent;
import com.emitrom.lienzo.client.core.event.NodeDragMoveHandler;
import com.emitrom.lienzo.client.core.shape.Group;
import com.emitrom.lienzo.client.core.shape.IPrimitive;
import com.emitrom.lienzo.client.core.shape.Layer;
import com.emitrom.lienzo.client.core.types.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.uberfire.ext.wires.core.api.controlpoints.ControlPoint;
import org.uberfire.ext.wires.core.api.controlpoints.HasControlPoints;
import org.uberfire.ext.wires.core.api.magnets.HasMagnets;
import org.uberfire.ext.wires.core.api.magnets.Magnet;
import org.uberfire.ext.wires.core.api.shapes.WiresBaseShape;

public abstract class WiresBaseDynamicShape
extends WiresBaseShape
implements HasMagnets,
HasControlPoints {
    protected List<Magnet> magnets = new ArrayList<Magnet>();
    protected List<ControlPoint> controlPoints = new ArrayList<ControlPoint>();
    private boolean showingMagnets = false;
    private boolean showingControlPoints = false;

    public WiresBaseDynamicShape() {
        this.addNodeDragMoveHandler(new NodeDragMoveHandler(){

            public void onNodeDragMove(NodeDragMoveEvent nodeDragMoveEvent) {
                WiresBaseDynamicShape.this.updateMagnetOffsets();
                WiresBaseDynamicShape.this.updateControlPointOffsets();
                WiresBaseDynamicShape.this.getLayer().draw();
            }
        });
    }

    @Override
    public void addControlPoint(ControlPoint cp) {
        this.controlPoints.add(cp);
    }

    @Override
    public void showControlPoints() {
        Layer layer = this.getLayer();
        if (!this.controlPoints.isEmpty() && !this.showingControlPoints) {
            for (ControlPoint cp : this.controlPoints) {
                cp.setOffset(this.getLocation());
                layer.add((IPrimitive)cp);
            }
            this.showingControlPoints = true;
            this.getLayer().draw();
        }
    }

    @Override
    public void hideControlPoints() {
        Layer layer = this.getLayer();
        if (!this.controlPoints.isEmpty() && this.showingControlPoints) {
            for (ControlPoint cp : this.controlPoints) {
                layer.remove((IPrimitive)cp);
            }
            this.showingControlPoints = false;
            this.getLayer().draw();
        }
    }

    @Override
    public void addMagnet(Magnet m) {
        this.magnets.add(m);
    }

    @Override
    public List<Magnet> getMagnets() {
        return this.magnets;
    }

    @Override
    public void showMagnetsPoints() {
        Layer layer = this.getLayer();
        if (!this.magnets.isEmpty() && !this.showingMagnets) {
            for (Magnet m : this.magnets) {
                m.setOffset(this.getLocation());
                layer.add((IPrimitive)m);
            }
            this.showingMagnets = true;
            this.getLayer().draw();
        }
    }

    @Override
    public void hideMagnetPoints() {
        Layer layer = this.getLayer();
        if (!this.magnets.isEmpty() && this.showingMagnets) {
            for (Magnet m : this.magnets) {
                layer.remove((IPrimitive)m);
            }
            this.showingMagnets = false;
            this.getLayer().draw();
        }
    }

    @Override
    public void destroy() {
        this.hideControlPoints();
        this.hideMagnetPoints();
        super.destroy();
    }

    @Override
    public Group setX(double x) {
        Group g = super.setX(x);
        this.updateMagnetOffsets();
        this.updateControlPointOffsets();
        return g;
    }

    @Override
    public Group setY(double y) {
        Group g = super.setY(y);
        this.updateMagnetOffsets();
        this.updateControlPointOffsets();
        return g;
    }

    @Override
    public Group setLocation(Point2D p) {
        Group g = super.setLocation(p);
        this.updateMagnetOffsets();
        this.updateControlPointOffsets();
        return g;
    }

    public Group setOffset(Point2D offset) {
        Group g = super.setOffset(offset);
        this.updateMagnetOffsets();
        this.updateControlPointOffsets();
        return g;
    }

    protected void updateMagnetOffsets() {
        if (this.magnets == null) {
            return;
        }
        for (Magnet m : this.magnets) {
            m.setOffset(this.getLocation());
        }
    }

    protected void updateControlPointOffsets() {
        if (this.controlPoints == null) {
            return;
        }
        for (ControlPoint cp : this.controlPoints) {
            cp.setOffset(this.getLocation());
        }
    }
}

