/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.api.shapes;

import com.emitrom.lienzo.client.core.animation.AnimationProperties;
import com.emitrom.lienzo.client.core.animation.AnimationTweener;
import com.emitrom.lienzo.client.core.animation.IAnimation;
import com.emitrom.lienzo.client.core.animation.IAnimationCallback;
import com.emitrom.lienzo.client.core.animation.IAnimationHandle;
import com.emitrom.lienzo.client.core.event.NodeDragMoveEvent;
import com.emitrom.lienzo.client.core.event.NodeDragMoveHandler;
import com.emitrom.lienzo.client.core.event.NodeMouseClickEvent;
import com.emitrom.lienzo.client.core.event.NodeMouseClickHandler;
import com.emitrom.lienzo.client.core.shape.Group;
import com.emitrom.lienzo.client.core.shape.IPrimitive;
import com.emitrom.lienzo.client.core.shape.Layer;
import com.emitrom.lienzo.client.core.types.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.wires.core.api.selection.RequiresSelectionManager;
import org.uberfire.ext.wires.core.api.selection.SelectionManager;
import org.uberfire.ext.wires.core.api.shapes.UUID;
import org.uberfire.ext.wires.core.api.shapes.WiresShape;

public abstract class WiresBaseShape
extends Group
implements WiresShape,
RequiresSelectionManager {
    protected String id;
    protected SelectionManager selectionManager;
    protected List<Group> controls = new ArrayList<Group>();
    protected boolean isControlsVisible = false;
    private static final int ANIMATION_DURATION = 250;
    private static final int DEFAULT_CONTROL_SPACING = 30;
    private static final int DEFAULT_CONTROL_POSITION_X_OFFSET = 100;
    private static final int DEFAULT_CONTROL_POSITION_Y_OFFSET = 0;
    private IAnimationHandle animationHandle;

    public WiresBaseShape() {
        this.id = UUID.uuid();
        this.setDraggable(true);
        this.addNodeMouseClickHandler(new NodeMouseClickHandler(){

            public void onNodeMouseClick(NodeMouseClickEvent nodeMouseClickEvent) {
                WiresBaseShape.this.selectionManager.selectShape(WiresBaseShape.this);
            }
        });
        this.addNodeDragMoveHandler(new NodeDragMoveHandler(){

            public void onNodeDragMove(NodeDragMoveEvent nodeDragMoveEvent) {
                WiresBaseShape.this.updateControlLocations();
            }
        });
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setSelectionManager(SelectionManager manager) {
        this.selectionManager = manager;
    }

    @Override
    public void showControls() {
        if (this.controls == null || this.controls.isEmpty()) {
            return;
        }
        if (this.isControlsVisible) {
            return;
        }
        if (this.animationHandle != null) {
            this.animationHandle.stop();
        }
        this.isControlsVisible = true;
        this.animationHandle = this.animate(AnimationTweener.EASE_OUT, new AnimationProperties(), 250.0, new IAnimationCallback(){
            private final AnimationTweener tweener = AnimationTweener.TweenerBuilder.MAKE_ELASTIC((int)1);
            private final Map<Group, Pair<Point2D, Point2D>> transformations = new HashMap<Group, Pair<Point2D, Point2D>>();

            public void onStart(IAnimation iAnimation, IAnimationHandle iAnimationHandle) {
                this.transformations.clear();
                for (int index = 0; index < WiresBaseShape.this.controls.size(); ++index) {
                    Group ctrl = WiresBaseShape.this.controls.get(index);
                    Point2D origin = new Point2D(0.0, 0.0);
                    Point2D target = WiresBaseShape.this.getControlTarget(ctrl);
                    this.transformations.put(ctrl, (Pair<Point2D, Point2D>)new Pair((Object)origin, (Object)target));
                    WiresBaseShape.this.getLayer().add((IPrimitive)ctrl);
                    ctrl.setOffset(WiresBaseShape.this.getLocation());
                    ctrl.setLocation(origin);
                    ctrl.setAlpha(0.0);
                }
            }

            public void onFrame(IAnimation iAnimation, IAnimationHandle iAnimationHandle) {
                double pct = this.tweener.tween(iAnimation.getPercent() > 1.0 ? 1.0 : iAnimation.getPercent());
                for (Map.Entry<Group, Pair<Point2D, Point2D>> e : this.transformations.entrySet()) {
                    Point2D origin = (Point2D)e.getValue().getK1();
                    Point2D target = (Point2D)e.getValue().getK2();
                    double dx = (target.getX() - origin.getX()) * pct;
                    double dy = (target.getY() - origin.getY()) * pct;
                    e.getKey().setX(origin.getX() + dx);
                    e.getKey().setY(origin.getY() + dy);
                }
                for (Group ctrl : WiresBaseShape.this.controls) {
                    ctrl.setAlpha(iAnimation.getPercent());
                }
                WiresBaseShape.this.getLayer().draw();
            }

            public void onClose(IAnimation iAnimation, IAnimationHandle iAnimationHandle) {
            }
        });
    }

    @Override
    public void hideControls() {
        if (this.controls == null || this.controls.isEmpty()) {
            return;
        }
        if (!this.isControlsVisible) {
            return;
        }
        if (this.animationHandle != null) {
            this.animationHandle.stop();
        }
        this.isControlsVisible = false;
        this.animationHandle = this.animate(AnimationTweener.EASE_OUT, new AnimationProperties(), 250.0, new IAnimationCallback(){
            private final AnimationTweener tweener = AnimationTweener.TweenerBuilder.MAKE_EASE_IN((double)3.0);
            private final Map<Group, Pair<Point2D, Point2D>> transformations = new HashMap<Group, Pair<Point2D, Point2D>>();

            public void onStart(IAnimation iAnimation, IAnimationHandle iAnimationHandle) {
                this.transformations.clear();
                for (int index = 0; index < WiresBaseShape.this.controls.size(); ++index) {
                    Group ctrl = WiresBaseShape.this.controls.get(index);
                    Point2D target = new Point2D(0.0, 0.0);
                    this.transformations.put(ctrl, (Pair<Point2D, Point2D>)new Pair((Object)ctrl.getLocation(), (Object)target));
                }
            }

            public void onFrame(IAnimation iAnimation, IAnimationHandle iAnimationHandle) {
                double pct = this.tweener.tween(iAnimation.getPercent() > 1.0 ? 1.0 : iAnimation.getPercent());
                for (Map.Entry<Group, Pair<Point2D, Point2D>> e : this.transformations.entrySet()) {
                    Point2D origin = (Point2D)e.getValue().getK1();
                    Point2D target = (Point2D)e.getValue().getK2();
                    double dx = (target.getX() - origin.getX()) * pct;
                    double dy = (target.getY() - origin.getY()) * pct;
                    e.getKey().setX(origin.getX() + dx);
                    e.getKey().setY(origin.getY() + dy);
                }
                for (Group ctrl : WiresBaseShape.this.controls) {
                    ctrl.setAlpha(1.0 - iAnimation.getPercent());
                }
                WiresBaseShape.this.getLayer().draw();
            }

            public void onClose(IAnimation iAnimation, IAnimationHandle iAnimationHandle) {
                for (Group ctrl : WiresBaseShape.this.controls) {
                    WiresBaseShape.this.getLayer().remove((IPrimitive)ctrl);
                }
            }
        });
    }

    @Override
    public void addControl(Group ctrlToAdd) {
        if (!this.isControlsVisible) {
            this.controls.add(ctrlToAdd);
            return;
        }
        ArrayList<Group> newControls = new ArrayList<Group>(this.controls);
        newControls.add(ctrlToAdd);
        this.setControls(newControls);
    }

    @Override
    public void removeControl(Group ctrlToRemove) {
        if (!this.isControlsVisible) {
            this.controls.remove(ctrlToRemove);
            return;
        }
        ArrayList<Group> newControls = new ArrayList<Group>(this.controls);
        newControls.remove(ctrlToRemove);
        this.setControls(newControls);
    }

    @Override
    public void setControls(final List<Group> newControls) {
        if (!this.isControlsVisible) {
            this.controls.clear();
            this.controls.addAll(newControls);
            return;
        }
        if (this.animationHandle != null) {
            this.animationHandle.stop();
        }
        this.animationHandle = this.animate(AnimationTweener.EASE_OUT, new AnimationProperties(), 250.0, new IAnimationCallback(){
            private final List<Group> controlsToAdd = new ArrayList<Group>();
            private final List<Group> controlsToRemove = new ArrayList<Group>();
            private final List<Group> controlsToRemain = new ArrayList<Group>();
            private final AnimationTweener tweener = AnimationTweener.TweenerBuilder.MAKE_ELASTIC((int)1);
            private final Map<Group, Pair<Point2D, Point2D>> transformations = new HashMap<Group, Pair<Point2D, Point2D>>();

            public void onStart(IAnimation iAnimation, IAnimationHandle iAnimationHandle) {
                Point2D target;
                Point2D origin;
                this.controlsToAdd.clear();
                this.controlsToAdd.addAll(newControls);
                this.controlsToAdd.removeAll(WiresBaseShape.this.controls);
                for (Group ctrl : this.controlsToAdd) {
                    ctrl.setLocation(new Point2D(0.0, 0.0));
                    ctrl.setAlpha(0.0);
                    ctrl.setOffset(WiresBaseShape.this.getLocation());
                    WiresBaseShape.this.getLayer().add((IPrimitive)ctrl);
                }
                this.controlsToRemove.clear();
                this.controlsToRemove.addAll(WiresBaseShape.this.controls);
                this.controlsToRemove.removeAll(newControls);
                this.controlsToRemain.clear();
                this.controlsToRemain.addAll(WiresBaseShape.this.controls);
                this.controlsToRemain.removeAll(this.controlsToAdd);
                this.controlsToRemain.removeAll(this.controlsToRemove);
                WiresBaseShape.this.controls.clear();
                WiresBaseShape.this.controls.addAll(newControls);
                this.transformations.clear();
                for (Group ctrl : this.controlsToAdd) {
                    origin = new Point2D(0.0, 0.0);
                    target = WiresBaseShape.this.getControlTarget(ctrl);
                    this.transformations.put(ctrl, (Pair<Point2D, Point2D>)new Pair((Object)origin, (Object)target));
                }
                for (Group ctrl : this.controlsToRemove) {
                    origin = ctrl.getLocation();
                    target = new Point2D(0.0, 0.0);
                    this.transformations.put(ctrl, (Pair<Point2D, Point2D>)new Pair((Object)origin, (Object)target));
                }
                for (Group ctrl : this.controlsToRemain) {
                    origin = ctrl.getLocation();
                    target = WiresBaseShape.this.getControlTarget(ctrl);
                    this.transformations.put(ctrl, (Pair<Point2D, Point2D>)new Pair((Object)origin, (Object)target));
                }
            }

            public void onFrame(IAnimation iAnimation, IAnimationHandle iAnimationHandle) {
                double pct = this.tweener.tween(iAnimation.getPercent() > 1.0 ? 1.0 : iAnimation.getPercent());
                for (Map.Entry<Group, Pair<Point2D, Point2D>> e : this.transformations.entrySet()) {
                    Point2D origin = (Point2D)e.getValue().getK1();
                    Point2D target = (Point2D)e.getValue().getK2();
                    double dx = (target.getX() - origin.getX()) * pct;
                    double dy = (target.getY() - origin.getY()) * pct;
                    e.getKey().setX(origin.getX() + dx);
                    e.getKey().setY(origin.getY() + dy);
                }
                for (Group ctrl : this.controlsToAdd) {
                    ctrl.setAlpha(pct);
                }
                for (Group ctrl : this.controlsToRemove) {
                    ctrl.setAlpha(1.0 - pct);
                }
                WiresBaseShape.this.getLayer().draw();
            }

            public void onClose(IAnimation iAnimation, IAnimationHandle iAnimationHandle) {
                WiresBaseShape.this.isControlsVisible = !WiresBaseShape.this.controls.isEmpty();
                for (Group ctrl : this.controlsToRemove) {
                    WiresBaseShape.this.getLayer().remove((IPrimitive)ctrl);
                }
            }
        });
    }

    @Override
    public boolean isControlsVisible() {
        return this.isControlsVisible;
    }

    protected Point2D getControlTarget(Group ctrl) {
        int offsetY = -((this.controls.size() - 1) * 30) / 2;
        Point2D target = new Point2D(100.0, (double)(0 + offsetY + this.controls.indexOf(ctrl) * 30));
        return target;
    }

    @Override
    public void destroy() {
        if (this.isControlsVisible) {
            for (Group ctrl : this.controls) {
                this.getLayer().remove((IPrimitive)ctrl);
            }
            this.isControlsVisible = false;
        }
        Layer layer = this.getLayer();
        layer.remove((IPrimitive)this);
        layer.draw();
    }

    private void updateControlLocations() {
        if (this.controls == null) {
            return;
        }
        if (!this.isControlsVisible) {
            return;
        }
        for (Group ctrl : this.controls) {
            ctrl.setOffset(this.getLocation());
        }
    }

    public Group setX(double x) {
        Group g = super.setX(x);
        this.updateControlLocations();
        return g;
    }

    public Group setY(double y) {
        Group g = super.setY(y);
        this.updateControlLocations();
        return g;
    }

    public Group setLocation(Point2D p) {
        Group g = super.setLocation(p);
        this.updateControlLocations();
        return g;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WiresBaseShape)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WiresBaseShape that = (WiresBaseShape)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.id.hashCode();
        return result;
    }
}

