/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.api.shapes;

import com.ait.lienzo.client.core.event.NodeDragMoveEvent;
import com.ait.lienzo.client.core.event.NodeDragMoveHandler;
import com.ait.lienzo.client.core.event.NodeDragStartEvent;
import com.ait.lienzo.client.core.event.NodeDragStartHandler;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.types.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.wires.core.api.containers.WiresContainer;
import org.uberfire.ext.wires.core.api.shapes.RequiresShapesManager;
import org.uberfire.ext.wires.core.api.shapes.ShapesManager;
import org.uberfire.ext.wires.core.api.shapes.WiresBaseDynamicShape;
import org.uberfire.ext.wires.core.api.shapes.WiresBaseShape;

public abstract class WiresBaseDynamicContainer
extends WiresBaseDynamicShape
implements WiresContainer,
RequiresShapesManager {
    private List<WiresBaseShape> children = new ArrayList<WiresBaseShape>();
    private List<Pair<WiresBaseShape, Point2D>> dragStartLocations = new ArrayList<Pair<WiresBaseShape, Point2D>>();
    protected ShapesManager shapesManager;

    public WiresBaseDynamicContainer() {
        this.addNodeDragStartHandler(new NodeDragStartHandler(){

            public void onNodeDragStart(NodeDragStartEvent nodeDragStartEvent) {
                WiresBaseDynamicContainer.this.dragStartLocations.clear();
                for (WiresBaseShape shape : WiresBaseDynamicContainer.this.children) {
                    WiresBaseDynamicContainer.this.dragStartLocations.add(new Pair((Object)shape, (Object)new Point2D(shape.getLocation().getX(), shape.getLocation().getY())));
                }
            }
        });
        this.addNodeDragMoveHandler(new NodeDragMoveHandler(){

            public void onNodeDragMove(NodeDragMoveEvent nodeDragMoveEvent) {
                double deltaX = nodeDragMoveEvent.getDragContext().getDx();
                double deltaY = nodeDragMoveEvent.getDragContext().getDy();
                Point2D delta = new Point2D(deltaX, deltaY);
                for (Pair dragStartLocation : WiresBaseDynamicContainer.this.dragStartLocations) {
                    ((WiresBaseShape)dragStartLocation.getK1()).setLocation(((Point2D)dragStartLocation.getK2()).add(delta));
                }
                WiresBaseDynamicContainer.this.getLayer().draw();
            }
        });
    }

    @Override
    public void setShapesManager(ShapesManager shapesManager) {
        this.shapesManager = shapesManager;
    }

    @Override
    public void attachShape(WiresBaseShape shape) {
        this.children.add(shape);
    }

    @Override
    public void detachShape(WiresBaseShape shape) {
        this.children.remove(shape);
    }

    @Override
    public List<WiresBaseShape> getContainedShapes() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public Group setX(double x) {
        this.updateChildrenLocations(x - this.getX(), 0.0);
        return super.setX(x);
    }

    @Override
    public Group setY(double y) {
        this.updateChildrenLocations(0.0, y - this.getY());
        return super.setY(y);
    }

    protected void updateChildrenLocations(double deltaX, double deltaY) {
        if (this.children == null) {
            return;
        }
        Point2D delta = new Point2D(deltaX, deltaY);
        for (WiresBaseShape shape : this.children) {
            shape.setLocation(shape.getLocation().add(delta));
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        for (WiresBaseShape shape : this.children) {
            this.shapesManager.forceDeleteShape(shape);
        }
    }
}

