/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.api.shapes;

import com.ait.lienzo.client.core.event.NodeDragMoveEvent;
import com.ait.lienzo.client.core.event.NodeDragMoveHandler;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Layer;
import java.util.ArrayList;
import java.util.List;
import org.uberfire.ext.wires.core.api.controlpoints.ControlPoint;
import org.uberfire.ext.wires.core.api.controlpoints.HasControlPoints;
import org.uberfire.ext.wires.core.api.magnets.HasMagnets;
import org.uberfire.ext.wires.core.api.magnets.Magnet;
import org.uberfire.ext.wires.core.api.shapes.WiresBaseShape;

public abstract class WiresBaseDynamicShape
extends WiresBaseShape
implements HasMagnets,
HasControlPoints {
    protected List<Magnet> magnets = new ArrayList<Magnet>();
    protected List<ControlPoint> controlPoints = new ArrayList<ControlPoint>();
    private boolean showingMagnets = false;
    private boolean showingControlPoints = false;

    public WiresBaseDynamicShape() {
        this.addNodeDragMoveHandler(new NodeDragMoveHandler(){

            public void onNodeDragMove(NodeDragMoveEvent nodeDragMoveEvent) {
                WiresBaseDynamicShape.this.updateMagnetLocations(0.0, 0.0);
                WiresBaseDynamicShape.this.updateControlPointLocations(0.0, 0.0);
                WiresBaseDynamicShape.this.getLayer().draw();
            }
        });
    }

    @Override
    public void addControlPoint(ControlPoint cp) {
        this.controlPoints.add(cp);
    }

    @Override
    public void showControlPoints() {
        Layer layer = this.getLayer();
        if (!this.controlPoints.isEmpty() && !this.showingControlPoints) {
            for (ControlPoint cp : this.controlPoints) {
                layer.add((IPrimitive)cp);
            }
            this.showingControlPoints = true;
            this.getLayer().draw();
        }
    }

    @Override
    public void hideControlPoints() {
        Layer layer = this.getLayer();
        if (!this.controlPoints.isEmpty() && this.showingControlPoints) {
            for (ControlPoint cp : this.controlPoints) {
                layer.remove((IPrimitive)cp);
            }
            this.showingControlPoints = false;
            this.getLayer().draw();
        }
    }

    @Override
    public void addMagnet(Magnet m) {
        this.magnets.add(m);
    }

    @Override
    public List<Magnet> getMagnets() {
        return this.magnets;
    }

    @Override
    public void showMagnetsPoints() {
        Layer layer = this.getLayer();
        if (!this.magnets.isEmpty() && !this.showingMagnets) {
            for (Magnet m : this.magnets) {
                layer.add((IPrimitive)m);
            }
            this.showingMagnets = true;
            this.getLayer().draw();
        }
    }

    @Override
    public void hideMagnetPoints() {
        Layer layer = this.getLayer();
        if (!this.magnets.isEmpty() && this.showingMagnets) {
            for (Magnet m : this.magnets) {
                layer.remove((IPrimitive)m);
            }
            this.showingMagnets = false;
            this.getLayer().draw();
        }
    }

    @Override
    public void destroy() {
        this.hideControlPoints();
        this.hideMagnetPoints();
        super.destroy();
    }

    @Override
    public Group setX(double x) {
        double dx = x - this.getX();
        double dy = 0.0;
        this.updateMagnetLocations(dx, 0.0);
        this.updateControlPointLocations(dx, 0.0);
        Group g = super.setX(x);
        return g;
    }

    @Override
    public Group setY(double y) {
        double dx = 0.0;
        double dy = y - this.getY();
        this.updateMagnetLocations(0.0, dy);
        this.updateControlPointLocations(0.0, dy);
        Group g = super.setY(y);
        return g;
    }

    protected void updateMagnetLocations(double dx, double dy) {
        if (this.magnets == null) {
            return;
        }
        for (Magnet m : this.magnets) {
            m.move(dx, dy);
        }
    }

    protected void updateControlPointLocations(double dx, double dy) {
        if (this.controlPoints == null) {
            return;
        }
        for (ControlPoint cp : this.controlPoints) {
            cp.move(dx, dy);
        }
    }
}

