/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.client.canvas;

import com.emitrom.lienzo.client.core.shape.GridLayer;
import com.emitrom.lienzo.client.core.shape.IPrimitive;
import com.emitrom.lienzo.client.core.shape.Layer;
import com.emitrom.lienzo.client.core.shape.Line;
import com.emitrom.lienzo.shared.core.types.ColorName;
import com.emitrom.lienzo.shared.core.types.IColor;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import org.uberfire.ext.wires.core.api.containers.WiresContainer;
import org.uberfire.ext.wires.core.api.controlpoints.HasControlPoints;
import org.uberfire.ext.wires.core.api.magnets.HasMagnets;
import org.uberfire.ext.wires.core.api.magnets.Magnet;
import org.uberfire.ext.wires.core.api.magnets.MagnetManager;
import org.uberfire.ext.wires.core.api.magnets.RequiresMagnetManager;
import org.uberfire.ext.wires.core.api.selection.SelectionManager;
import org.uberfire.ext.wires.core.api.shapes.RequiresShapesManager;
import org.uberfire.ext.wires.core.api.shapes.ShapesManager;
import org.uberfire.ext.wires.core.api.shapes.WiresBaseShape;
import org.uberfire.ext.wires.core.api.shapes.WiresShape;
import org.uberfire.ext.wires.core.client.canvas.FocusableLienzoPanel;
import org.uberfire.ext.wires.core.client.progressbar.ProgressBar;

public class WiresCanvas
extends Composite
implements ShapesManager,
SelectionManager,
MagnetManager {
    public static final int DEFAULT_SIZE_WIDTH = 1000;
    public static final int DEFAULT_SIZE_HEIGHT = 1000;
    private FocusableLienzoPanel panel;
    private WiresBaseShape selectedShape;
    private ProgressBar progressBar;
    protected Layer canvasLayer;
    protected List<WiresBaseShape> shapesInCanvas = new ArrayList<WiresBaseShape>();

    @PostConstruct
    public void init() {
        this.panel = new FocusableLienzoPanel(1000, 1000);
        this.initWidget((Widget)this.panel);
        this.canvasLayer = new Layer(){
            private boolean scheduled = false;

            public void draw() {
                if (!this.scheduled) {
                    this.scheduled = true;
                    Scheduler.get().scheduleFinally((Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            this.doDraw();
                        }
                    });
                }
            }

            private void doDraw() {
                this.scheduled = false;
                super.draw();
            }
        };
        Line line1 = (Line)((Line)new Line(0.0, 0.0, 0.0, 0.0).setStrokeColor((IColor)ColorName.BLUE)).setAlpha(0.5);
        Line line2 = (Line)((Line)new Line(0.0, 0.0, 0.0, 0.0).setStrokeColor((IColor)ColorName.GREEN)).setAlpha(0.5);
        line2.setDashArray(2.0, new double[]{2.0});
        GridLayer gridLayer = new GridLayer(100.0, line1, 25.0, line2);
        this.panel.setBackgroundLayer((Layer)gridLayer);
        this.panel.getScene().add(this.canvasLayer);
    }

    public boolean hasProgressBar() {
        return this.progressBar != null;
    }

    public ProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void setProgressBar(ProgressBar progressBar) {
        this.progressBar = progressBar;
        this.canvasLayer.add((IPrimitive)progressBar);
        this.canvasLayer.draw();
    }

    public List<WiresBaseShape> getShapesInCanvas() {
        return Collections.unmodifiableList(this.shapesInCanvas);
    }

    public void addShape(WiresBaseShape shape) {
        shape.setSelectionManager((SelectionManager)this);
        if (shape instanceof RequiresShapesManager) {
            ((RequiresShapesManager)shape).setShapesManager((ShapesManager)this);
        }
        if (shape instanceof RequiresMagnetManager) {
            ((RequiresMagnetManager)shape).setMagnetManager((MagnetManager)this);
        }
        this.canvasLayer.add((IPrimitive)shape);
        this.shapesInCanvas.add(shape);
        if (shape instanceof WiresContainer) {
            shape.moveToBottom();
        }
        this.canvasLayer.draw();
    }

    public void deleteShape(WiresBaseShape shape) {
        shape.destroy();
        this.deselectShape(shape);
        this.canvasLayer.remove((IPrimitive)shape);
        this.shapesInCanvas.remove(shape);
        this.canvasLayer.draw();
    }

    public void forceDeleteShape(WiresBaseShape shape) {
        this.deleteShape(shape);
    }

    public void clear() {
        for (WiresShape wiresShape : this.shapesInCanvas) {
            if (!(wiresShape instanceof WiresContainer)) continue;
            WiresContainer wc = (WiresContainer)wiresShape;
            for (WiresBaseShape bc : wc.getContainedShapes()) {
                wc.detachShape(bc);
            }
        }
        for (WiresShape wiresShape : this.shapesInCanvas) {
            wiresShape.destroy();
            this.canvasLayer.remove((IPrimitive)wiresShape);
        }
        this.clearSelection();
        this.shapesInCanvas.clear();
        this.panel.getViewport().setPixelSize(1000, 1000);
        this.panel.getViewport().draw();
    }

    public void clearSelection() {
        this.selectedShape = null;
        for (WiresShape wiresShape : this.getShapesInCanvas()) {
            wiresShape.setSelected(false);
            if (wiresShape instanceof HasControlPoints) {
                ((HasControlPoints)wiresShape).hideControlPoints();
            }
            if (!(wiresShape instanceof HasMagnets)) continue;
            ((HasMagnets)wiresShape).hideMagnetPoints();
        }
        this.canvasLayer.draw();
    }

    public void selectShape(WiresBaseShape shape) {
        if (shape == null) {
            return;
        }
        if (shape.equals((Object)this.selectedShape)) {
            return;
        }
        this.clearSelection();
        this.selectedShape = shape;
        this.selectedShape.setSelected(true);
        if (shape instanceof HasControlPoints) {
            ((HasControlPoints)this.selectedShape).showControlPoints();
        }
        this.canvasLayer.draw();
    }

    public void deselectShape(WiresBaseShape shape) {
        if (shape == null) {
            return;
        }
        this.selectedShape = null;
        if (shape instanceof HasControlPoints) {
            ((HasControlPoints)shape).hideControlPoints();
        }
        if (shape instanceof HasMagnets) {
            ((HasMagnets)shape).hideMagnetPoints();
        }
        this.canvasLayer.draw();
    }

    public boolean isShapeSelected() {
        return this.selectedShape != null;
    }

    public WiresBaseShape getSelectedShape() {
        return this.selectedShape;
    }

    public void hideAllMagnets() {
        for (WiresShape wiresShape : this.getShapesInCanvas()) {
            if (!(wiresShape instanceof HasMagnets)) continue;
            HasMagnets mShape = (HasMagnets)wiresShape;
            mShape.hideMagnetPoints();
        }
    }

    public Magnet getMagnet(WiresShape activeShape, double cx, double cy) {
        if (activeShape == null) {
            return null;
        }
        Magnet selectedMagnet = null;
        double finalDistance = Double.MAX_VALUE;
        for (WiresShape wiresShape : this.getShapesInCanvas()) {
            if (wiresShape.getId().equals(activeShape.getId()) || !(wiresShape instanceof HasMagnets)) continue;
            HasMagnets mShape = (HasMagnets)wiresShape;
            if (wiresShape.contains(cx, cy)) {
                mShape.showMagnetsPoints();
                List magnets = mShape.getMagnets();
                for (Magnet magnet : magnets) {
                    magnet.setActive(false);
                    double deltaX = cx - magnet.getX() - magnet.getOffset().getX();
                    double deltaY = cy - magnet.getY() - magnet.getOffset().getY();
                    double distance = Math.sqrt(Math.pow(deltaX, 2.0) + Math.pow(deltaY, 2.0));
                    if (!(finalDistance > distance)) continue;
                    finalDistance = distance;
                    if (selectedMagnet != null) {
                        selectedMagnet.setActive(false);
                    }
                    selectedMagnet = magnet;
                }
                if (selectedMagnet == null) continue;
                selectedMagnet.setActive(true);
                continue;
            }
            mShape.hideMagnetPoints();
        }
        return selectedMagnet;
    }
}

