/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.client.controlpoints;

import com.emitrom.lienzo.client.core.event.NodeDragEndEvent;
import com.emitrom.lienzo.client.core.event.NodeDragEndHandler;
import com.emitrom.lienzo.client.core.event.NodeDragMoveEvent;
import com.emitrom.lienzo.client.core.event.NodeDragMoveHandler;
import org.uberfire.ext.wires.core.api.controlpoints.ControlPoint;
import org.uberfire.ext.wires.core.api.controlpoints.ControlPointMoveHandler;
import org.uberfire.ext.wires.core.api.controlpoints.HasControlPoints;
import org.uberfire.ext.wires.core.api.magnets.Magnet;
import org.uberfire.ext.wires.core.api.magnets.MagnetManager;
import org.uberfire.ext.wires.core.api.shapes.WiresShape;
import org.uberfire.ext.wires.core.client.controlpoints.DefaultControlPoint;

public class ConnectibleControlPoint
extends DefaultControlPoint {
    private static final int MAGNET_ATTRACTION = 30;
    private Magnet boundMagnet;
    private final HasControlPoints shape;
    private final MagnetManager magnetManager;

    public ConnectibleControlPoint(double x, double y, HasControlPoints shape, MagnetManager magnetManager, ControlPointMoveHandler cpMoveHandler) {
        super(x, y, cpMoveHandler);
        this.shape = shape;
        this.magnetManager = magnetManager;
    }

    @Override
    protected void setupHandlers(final ControlPointMoveHandler handler) {
        this.addNodeDragMoveHandler(new NodeDragMoveHandler(){

            public void onNodeDragMove(NodeDragMoveEvent nodeDragMoveEvent) {
                handler.onMove(ConnectibleControlPoint.this.getX(), ConnectibleControlPoint.this.getY());
                if (ConnectibleControlPoint.this.boundMagnet != null) {
                    ConnectibleControlPoint.this.boundMagnet.detachControlPoint((ControlPoint)ConnectibleControlPoint.this);
                }
                ConnectibleControlPoint.this.boundMagnet = ConnectibleControlPoint.this.magnetManager.getMagnet((WiresShape)ConnectibleControlPoint.this.shape, ConnectibleControlPoint.this.getX() + ConnectibleControlPoint.this.getOffset().getX(), ConnectibleControlPoint.this.getY() + ConnectibleControlPoint.this.getOffset().getY());
                ConnectibleControlPoint.this.getLayer().draw();
            }
        });
        this.addNodeDragEndHandler(new NodeDragEndHandler(){

            public void onNodeDragEnd(NodeDragEndEvent nodeDragEndEvent) {
                if (ConnectibleControlPoint.this.boundMagnet != null) {
                    double deltaX = ConnectibleControlPoint.this.getX() + ConnectibleControlPoint.this.getOffset().getX() - (ConnectibleControlPoint.this.boundMagnet.getX() + ConnectibleControlPoint.this.boundMagnet.getOffset().getX());
                    double deltaY = ConnectibleControlPoint.this.getY() + ConnectibleControlPoint.this.getOffset().getY() - (ConnectibleControlPoint.this.boundMagnet.getY() + ConnectibleControlPoint.this.boundMagnet.getOffset().getY());
                    double distance = Math.sqrt(Math.pow(deltaX, 2.0) + Math.pow(deltaY, 2.0));
                    if (distance < 30.0) {
                        ConnectibleControlPoint.this.boundMagnet.attachControlPoint((ControlPoint)ConnectibleControlPoint.this);
                        double x = ConnectibleControlPoint.this.boundMagnet.getX() + ConnectibleControlPoint.this.boundMagnet.getOffset().getX() - ConnectibleControlPoint.this.getOffset().getX();
                        double y = ConnectibleControlPoint.this.boundMagnet.getY() + ConnectibleControlPoint.this.boundMagnet.getOffset().getY() - ConnectibleControlPoint.this.getOffset().getY();
                        ConnectibleControlPoint.this.setX(x);
                        ConnectibleControlPoint.this.setY(y);
                        handler.onMove(x, y);
                    }
                }
                ConnectibleControlPoint.this.magnetManager.hideAllMagnets();
                ConnectibleControlPoint.this.getLayer().draw();
            }
        });
    }

    public Magnet getBoundMagnet() {
        return this.boundMagnet;
    }

    @Override
    public String toString() {
        return "ConnectibleControlPoint{id=" + this.getId() + "}";
    }
}

