/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.client.controlpoints;

import com.emitrom.lienzo.client.core.event.NodeDragMoveEvent;
import com.emitrom.lienzo.client.core.event.NodeDragMoveHandler;
import com.emitrom.lienzo.client.core.shape.Circle;
import org.uberfire.ext.wires.core.api.controlpoints.ControlPoint;
import org.uberfire.ext.wires.core.api.controlpoints.ControlPointMoveHandler;
import org.uberfire.ext.wires.core.api.shapes.UUID;

public class DefaultControlPoint
extends Circle
implements ControlPoint<Circle> {
    private static final int RADIUS = 8;
    private final String id = UUID.uuid();
    private final ControlPointMoveHandler cpMoveHandler;

    public DefaultControlPoint(double x, double y, ControlPointMoveHandler cpMoveHandler) {
        super(8.0);
        this.cpMoveHandler = cpMoveHandler;
        this.setFillColor("#0000FF");
        this.setStrokeWidth(1.0);
        this.setX(x);
        this.setY(y);
        this.setDraggable(true);
        this.setupHandlers(cpMoveHandler);
    }

    public String getId() {
        return this.id;
    }

    public ControlPointMoveHandler getHandler() {
        return this.cpMoveHandler;
    }

    protected void setupHandlers(final ControlPointMoveHandler moveHandler) {
        this.addNodeDragMoveHandler(new NodeDragMoveHandler(){

            public void onNodeDragMove(NodeDragMoveEvent nodeDragMoveEvent) {
                moveHandler.onMove(DefaultControlPoint.this.getX(), DefaultControlPoint.this.getY());
                DefaultControlPoint.this.getLayer().draw();
            }
        });
    }

    public String toString() {
        return "DefaultControlPoint{id=" + this.id + "}";
    }
}

