/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.client.palette;

import com.emitrom.lienzo.client.core.shape.IPrimitive;
import com.emitrom.lienzo.client.core.shape.Layer;
import com.emitrom.lienzo.client.widget.LienzoPanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.uberfire.ext.wires.core.api.factories.ShapeFactory;
import org.uberfire.ext.wires.core.api.factories.categories.Category;
import org.uberfire.ext.wires.core.client.canvas.FocusableLienzoPanel;
import org.uberfire.ext.wires.core.client.factories.ShapeFactoryCache;
import org.uberfire.ext.wires.core.client.factories.StringFactoryHelper;
import org.uberfire.ext.wires.core.client.palette.PaletteLayoutUtilities;
import org.uberfire.ext.wires.core.client.palette.PaletteShape;
import org.uberfire.ext.wires.core.client.palette.StencilPaletteBuilder;
import org.uberfire.ext.wires.core.client.util.ShapesUtils;

public abstract class BaseGroup
extends Composite {
    private Layer layer;
    private LienzoPanel panel;
    @Inject
    private ShapeFactoryCache factoriesCache;
    @Inject
    private StencilPaletteBuilder stencilBuilder;

    @PostConstruct
    public void init() {
        this.panel = new FocusableLienzoPanel(405, ShapesUtils.calculateHeight(ShapesUtils.getNumberOfShapesInCategory(this.getCategory(), this.factoriesCache.getShapeFactories())));
        this.layer = new Layer();
        this.panel.getScene().add(this.layer);
        this.initWidget((Widget)this.panel);
        this.drawStencils();
    }

    public abstract Category getCategory();

    protected void drawStencils() {
        Category category = this.getCategory();
        ArrayList<PaletteShape> shapes = new ArrayList<PaletteShape>();
        for (ShapeFactory factory : this.factoriesCache.getShapeFactories()) {
            if (!factory.getCategory().equals((Object)category)) continue;
            shapes.add(this.stencilBuilder.build(this.panel, new StringFactoryHelper(factory.getShapeDescription()), factory));
        }
        int shapeCount = 1;
        for (PaletteShape shape : shapes) {
            shape.setX(PaletteLayoutUtilities.getX(shapeCount));
            shape.setY(PaletteLayoutUtilities.getY(shapeCount));
            this.layer.add((IPrimitive)shape);
            ++shapeCount;
        }
        this.layer.draw();
    }
}

