/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.client.actions;

import com.ait.lienzo.client.core.event.NodeMouseClickEvent;
import com.ait.lienzo.client.core.event.NodeMouseClickHandler;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.widget.LienzoPanel;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.uberfire.ext.wires.core.api.events.ClearEvent;
import org.uberfire.ext.wires.core.client.actions.ActionShape;
import org.uberfire.ext.wires.core.client.actions.StencilActionBuilder;
import org.uberfire.ext.wires.core.client.canvas.FocusableLienzoPanel;
import org.uberfire.ext.wires.core.client.palette.PaletteLayoutUtilities;
import org.uberfire.ext.wires.core.client.resources.AppResource;
import org.uberfire.ext.wires.core.client.util.ShapesUtils;

@Dependent
public class ActionsGroup
extends Composite {
    private Layer layer;
    private LienzoPanel panel;
    @Inject
    private Event<ClearEvent> clearEvent;
    @Inject
    private StencilActionBuilder stencilBuilder;

    @PostConstruct
    public void init() {
        this.panel = new FocusableLienzoPanel(405, ShapesUtils.calculateHeight(1));
        this.layer = new Layer();
        this.panel.getScene().add(this.layer);
        this.initWidget((Widget)this.panel);
        this.drawActions();
    }

    private void drawActions() {
        ArrayList<ActionShape> shapes = new ArrayList<ActionShape>();
        shapes.add(this.stencilBuilder.build(this.getClearCanvasClickHandler(), AppResource.INSTANCE.images().clear()));
        this.layer.draw();
        int shapeCount = 1;
        for (ActionShape shape : shapes) {
            shape.setX(0.0);
            shape.setY(PaletteLayoutUtilities.getY(shapeCount));
            this.layer.add((IPrimitive)shape);
            ++shapeCount;
        }
    }

    private NodeMouseClickHandler getClearCanvasClickHandler() {
        return new NodeMouseClickHandler(){

            public void onNodeMouseClick(NodeMouseClickEvent event) {
                if (Window.confirm((String)"Are you sure to clean the canvas?")) {
                    ActionsGroup.this.clearEvent.fire((Object)new ClearEvent());
                }
            }
        };
    }
}

