/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.client.progressbar;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.core.shape.Rectangle;
import com.ait.lienzo.client.core.shape.Text;
import com.ait.lienzo.client.core.types.LinearGradient;
import com.ait.lienzo.client.core.types.Shadow;
import com.ait.lienzo.shared.core.types.ColorName;
import com.ait.lienzo.shared.core.types.TextAlign;
import com.ait.lienzo.shared.core.types.TextBaseLine;
import com.google.gwt.user.client.Timer;

public class ProgressBar
extends Group {
    private Timer timer;
    private static boolean infinite = true;
    private Rectangle substrate;
    private static int substrateWidth = 300;
    private static int substrateHeight = 34;
    private String substrateColor = "#666";
    private LinearGradient substrateGradient;
    private Rectangle progress;
    private int progressWidth = 0;
    private int progressHeight = 0;
    private int width = 0;
    private int height = 0;
    private LinearGradient progressGradient;
    private Text progressPercentage;
    private final int PROGRESS_MARGIN = 4;
    private Layer layer;

    public ProgressBar(int width, int height, Layer layer) {
        ProgressBar.setInfinite(true);
        this.layer = layer;
        this.width = width;
        this.height = height;
        this.progressHeight = substrateHeight - 4;
        this.init();
        this.add((IPrimitive)this.substrate);
        this.add((IPrimitive)this.progress);
        this.add((IPrimitive)this.progressPercentage);
    }

    public void show() {
        infinite = true;
        this.setVisible(true);
        this.progressWidth = 0;
        this.timer.scheduleRepeating(1);
    }

    public void hide() {
        this.setVisible(false);
        this.timer.cancel();
    }

    public void center() {
        int x = (int)((double)(this.width / 2) - this.substrate.getWidth() / 2.0);
        int y = (int)((double)(this.height / 2) - this.substrate.getHeight() / 2.0);
        ((Rectangle)this.substrate.setX((double)x)).setY((double)y);
        ((Rectangle)this.progress.setX((double)(x + 2))).setY((double)(y + 2));
        ((Text)this.progressPercentage.setX((double)x + this.substrate.getWidth() / 2.0)).setY((double)(y + 2) + this.progress.getHeight() / 2.0);
        this.layer.draw();
    }

    public static int getSubstrateWidth() {
        return substrateWidth;
    }

    public void setProgressWidth(int progressWidth) {
        this.progressWidth = progressWidth;
        this.progress.setWidth((double)progressWidth);
    }

    public int getProgressWidth() {
        return this.progressWidth;
    }

    public Text getProgressPercentage() {
        return this.progressPercentage;
    }

    public Timer getTimer() {
        return this.timer;
    }

    private void init() {
        this.substrate = new Rectangle((double)substrateWidth, (double)substrateHeight);
        this.progress = new Rectangle((double)this.progressWidth, (double)this.progressHeight);
        this.progressPercentage = ((Text)((Text)new Text("0 %", "Lucida Console", 12.0).setFillColor(ColorName.WHITE.getValue())).setStrokeColor(this.substrateColor)).setTextBaseLine(TextBaseLine.MIDDLE).setTextAlign(TextAlign.CENTER);
        this.substrateGradient = new LinearGradient(0.0, (double)substrateHeight, 0.0, 0.0);
        this.substrateGradient.addColorStop(0.4, "rgba(255,255,255, 0.1)");
        this.substrateGradient.addColorStop(0.6, "rgba(255,255,255, 0.7)");
        this.substrateGradient.addColorStop(0.9, "rgba(255,255,255,0.4)");
        this.substrateGradient.addColorStop(1.0, "rgba(189,189,189,1)");
        ((Rectangle)((Rectangle)((Rectangle)this.substrate.setFillGradient(this.substrateGradient)).setShadow(new Shadow(this.substrateColor, 5, 3.0, 3.0))).setStrokeColor(this.substrateColor)).setStrokeWidth(1.0);
        this.progressGradient = new LinearGradient(0.0, -50.0, 0.0, 50.0);
        this.progressGradient.addColorStop(0.5, "#4DA4F3");
        this.progressGradient.addColorStop(0.8, "#ADD9FF");
        this.progressGradient.addColorStop(1.0, "#9ED1FF");
        this.progress.setFillGradient(this.progressGradient);
        this.center();
        this.progress();
    }

    private void progress() {
        this.timer = new Timer(){

            public void run() {
                if (!ProgressBar.isInfinite()) {
                    ProgressBar.this.hide();
                }
                ProgressBar.this.progressWidth++;
                if (ProgressBar.this.progressWidth > substrateWidth - 4) {
                    this.cancel();
                }
                ProgressBar.this.progressPercentage.setText(ProgressBar.this.progressWidth / 3 + " %");
                ProgressBar.this.setProgressWidth(ProgressBar.this.progressWidth);
                ProgressBar.this.layer.draw();
            }
        };
        this.timer.scheduleRepeating(1);
    }

    public static boolean isInfinite() {
        return infinite;
    }

    public static void setInfinite(boolean infinite) {
        ProgressBar.infinite = infinite;
    }
}

