/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.client.factories;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.container.IOCBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.wires.core.api.factories.ShapeFactory;

@ApplicationScoped
public class ShapeFactoryCache {
    @Inject
    private SyncBeanManager iocManager;
    private Set<ShapeFactory> factories = new HashSet<ShapeFactory>();

    @PostConstruct
    private void setup() {
        this.factories = this.getAvailableFactories();
    }

    public Set<ShapeFactory> getShapeFactories() {
        return Collections.unmodifiableSet(this.factories);
    }

    public void addShapeFactory(ShapeFactory factory) {
        this.factories.add((ShapeFactory)PortablePreconditions.checkNotNull((String)"factory", (Object)factory));
    }

    private Set<ShapeFactory> getAvailableFactories() {
        HashSet<ShapeFactory> factories = new HashSet<ShapeFactory>();
        Collection factoryBeans = this.iocManager.lookupBeans(ShapeFactory.class);
        for (IOCBeanDef factoryBean : factoryBeans) {
            factories.add((ShapeFactory)factoryBean.getInstance());
        }
        return factories;
    }
}

