/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.client.layers;

import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.widget.LienzoPanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.uberfire.ext.wires.core.api.factories.ShapeFactory;
import org.uberfire.ext.wires.core.api.shapes.WiresBaseShape;
import org.uberfire.ext.wires.core.client.canvas.FocusableLienzoPanel;
import org.uberfire.ext.wires.core.client.layers.LayerShape;
import org.uberfire.ext.wires.core.client.layers.StencilLayerBuilder;

@Dependent
public class LayersGroup
extends Composite {
    private Layer layer;
    private LienzoPanel panel;
    private List<LayerShape> stencils = new ArrayList<LayerShape>();
    private List<WiresBaseShape> shapes = new ArrayList<WiresBaseShape>();
    @Inject
    private StencilLayerBuilder stencilBuilder;

    @PostConstruct
    public void init() {
        this.panel = new FocusableLienzoPanel(405, 300);
        super.initWidget((Widget)this.panel);
        this.layer = new Layer();
        this.panel.getScene().add(this.layer);
    }

    public void addShape(WiresBaseShape shape, ShapeFactory factory) {
        LayerShape stencil = this.stencilBuilder.build(shape, factory);
        this.shapes.add(shape);
        this.stencils.add(stencil);
        stencil.setX(0.0);
        stencil.setY(35 * (this.shapes.size() - 1));
        this.layer.add((IPrimitive)stencil);
        this.layer.batch();
    }

    public void deleteShape(WiresBaseShape shape) {
        int index = this.shapes.indexOf(shape);
        this.layer.remove((IPrimitive)this.stencils.get(index));
        this.shapes.remove(index);
        this.stencils.remove(index);
        int shapeCount = 0;
        for (LayerShape stencil : this.stencils) {
            stencil.setY(35 * shapeCount);
            ++shapeCount;
        }
        this.layer.batch();
    }

    public void clearPanel() {
        this.shapes.clear();
        this.stencils.clear();
        this.layer.removeAll();
        this.layer.batch();
    }
}

