/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.client.properties;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.ext.properties.editor.client.PropertyEditorWidget;
import org.uberfire.ext.properties.editor.model.PropertyEditorCategory;
import org.uberfire.ext.properties.editor.model.PropertyEditorEvent;
import org.uberfire.ext.wires.core.api.events.ShapeSelectedEvent;
import org.uberfire.ext.wires.core.api.properties.PropertyEditorAdaptor;
import org.uberfire.ext.wires.core.api.shapes.WiresBaseShape;
import org.uberfire.ext.wires.core.client.properties.PropertyEditorAdaptorsCache;

@Dependent
@WorkbenchScreen(identifier="WiresPropertiesScreen")
public class PropertiesScreen
extends Composite {
    private static final String MY_ID = "WiresPropertiesScreen";
    private static ViewBinder uiBinder = (ViewBinder)GWT.create(ViewBinder.class);
    @UiField
    FlowPanel panel;
    @UiField
    PropertyEditorWidget propertyEditorWidget;
    @Inject
    PropertyEditorAdaptorsCache adaptors;
    private WiresBaseShape selectedShape;

    @PostConstruct
    public void init() {
        super.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return "Properties Editor";
    }

    @WorkbenchPartView
    public IsWidget getView() {
        return this;
    }

    public void onShapeSelectedEvent(@Observes ShapeSelectedEvent event) {
        this.selectedShape = event.getShape();
        this.propertyEditorWidget.handle(new PropertyEditorEvent(MY_ID, this.getProperties(this.selectedShape)));
    }

    protected List<PropertyEditorCategory> getProperties(WiresBaseShape shape) {
        ArrayList<PropertyEditorCategory> properties = new ArrayList<PropertyEditorCategory>();
        for (PropertyEditorAdaptor adaptor : this.adaptors.getAdaptors()) {
            if (!adaptor.supports(shape)) continue;
            properties.addAll(adaptor.getProperties(shape));
        }
        return properties;
    }

    static interface ViewBinder
    extends UiBinder<Widget, PropertiesScreen> {
    }
}

