/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.client.magnets;

import com.ait.lienzo.client.core.shape.Circle;
import com.ait.lienzo.client.core.types.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.uberfire.commons.uuid.UUID;
import org.uberfire.ext.wires.core.api.controlpoints.ControlPoint;
import org.uberfire.ext.wires.core.api.magnets.Magnet;

public class DefaultMagnet
extends Circle
implements Magnet<Circle> {
    private static final int RADIUS = 8;
    private final String id;
    private final List<ControlPoint> attachedControlPoints = new ArrayList<ControlPoint>();

    public DefaultMagnet(double x, double y) {
        super(8.0);
        this.id = UUID.uuid();
        this.setFillColor("#F2F2F2");
        this.setStrokeWidth(1.0);
        this.setX(x);
        this.setY(y);
        this.setDraggable(false);
    }

    public String getId() {
        return this.id;
    }

    public void attachControlPoint(ControlPoint controlPoint) {
        this.attachedControlPoints.add(controlPoint);
    }

    public void detachControlPoint(ControlPoint controlPoint) {
        this.attachedControlPoints.remove(controlPoint);
    }

    public List<ControlPoint> getAttachedControlPoints() {
        return this.attachedControlPoints;
    }

    public void setActive(boolean isActive) {
        if (isActive) {
            this.setFillColor("#00FF00");
        } else {
            this.setFillColor("#F2F2F2");
        }
    }

    public Circle setX(double x) {
        Circle c = (Circle)super.setX(x);
        this.moveAttachedControlPoints();
        return c;
    }

    public Circle setY(double y) {
        Circle c = (Circle)super.setY(y);
        this.moveAttachedControlPoints();
        return c;
    }

    public Circle setLocation(Point2D p) {
        Circle c = (Circle)super.setLocation(p);
        this.moveAttachedControlPoints();
        return c;
    }

    public void move(double dx, double dy) {
        this.setLocation(this.getLocation().add(new Point2D(dx, dy)));
    }

    protected void moveAttachedControlPoints() {
        List<ControlPoint> controlPoints = this.getAttachedControlPoints();
        if (controlPoints == null || controlPoints.isEmpty()) {
            return;
        }
        for (ControlPoint cp : controlPoints) {
            double dx = this.getX();
            double dy = this.getY();
            cp.setX(dx);
            cp.setY(dy);
            cp.getHandler().onMove(dx, dy);
        }
    }

    public String toString() {
        return "DefaultMagnet{id=" + this.id + '}';
    }
}

