/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.client.layers;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.PanelCollapse;
import org.gwtbootstrap3.client.ui.PanelGroup;
import org.gwtbootstrap3.client.ui.PanelHeader;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.ext.wires.core.api.events.ClearEvent;
import org.uberfire.ext.wires.core.api.events.ShapeAddedEvent;
import org.uberfire.ext.wires.core.api.events.ShapeDeletedEvent;
import org.uberfire.ext.wires.core.api.factories.ShapeFactory;
import org.uberfire.ext.wires.core.api.shapes.WiresBaseShape;
import org.uberfire.ext.wires.core.client.factories.ShapeFactoryCache;
import org.uberfire.ext.wires.core.client.layers.LayersGroup;

@Dependent
@WorkbenchScreen(identifier="WiresLayersScreen")
public class LayersScreen
extends Composite {
    private static ViewBinder uiBinder = (ViewBinder)GWT.create(ViewBinder.class);
    @UiField
    public SimplePanel layers;
    @UiField
    PanelGroup accordion;
    @UiField
    PanelHeader headerLayers;
    @UiField
    PanelCollapse collapseLayers;
    @Inject
    private LayersGroup layersGroup;
    @Inject
    private ShapeFactoryCache factoriesCache;

    @PostConstruct
    public void init() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.accordion.setId(DOM.createUniqueId());
        this.headerLayers.setDataParent(this.accordion.getId());
        this.headerLayers.setDataTargetWidget((Widget)this.collapseLayers);
        this.layers.add((Widget)this.layersGroup);
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return "Layers";
    }

    @WorkbenchPartView
    public IsWidget getView() {
        return this;
    }

    public void onShapeAdded(@Observes ShapeAddedEvent shapeAddedEvent) {
        WiresBaseShape shape = shapeAddedEvent.getShape();
        for (ShapeFactory factory : this.factoriesCache.getShapeFactories()) {
            if (!factory.builds(shape)) continue;
            this.layersGroup.addShape(shape, factory);
        }
    }

    public void onShapeDeleted(@Observes ShapeDeletedEvent shapeDeletedEvent) {
        WiresBaseShape shape = shapeDeletedEvent.getShape();
        this.layersGroup.deleteShape(shape);
    }

    public void onClear(@Observes ClearEvent event) {
        this.layersGroup.clearPanel();
    }

    static interface ViewBinder
    extends UiBinder<Widget, LayersScreen> {
    }
}

