/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.client.layers;

import com.ait.lienzo.client.core.event.NodeMouseClickEvent;
import com.ait.lienzo.client.core.event.NodeMouseClickHandler;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.Rectangle;
import com.ait.lienzo.client.core.shape.Text;
import com.ait.lienzo.shared.core.types.TextBaseLine;
import com.google.gwt.user.client.ui.Composite;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.uberfire.ext.wires.core.api.events.ShapeSelectedEvent;
import org.uberfire.ext.wires.core.api.factories.ShapeFactory;
import org.uberfire.ext.wires.core.api.factories.ShapeGlyph;
import org.uberfire.ext.wires.core.api.shapes.OverridesFactoryDescription;
import org.uberfire.ext.wires.core.api.shapes.WiresBaseShape;
import org.uberfire.ext.wires.core.client.layers.LayerShape;
import org.uberfire.ext.wires.core.client.util.ShapeFactoryUtil;

@ApplicationScoped
public class StencilLayerBuilder
extends Composite {
    private static final int GLYPH_WIDTH = 25;
    private static final int GLYPH_HEIGHT = 25;
    @Inject
    private Event<ShapeSelectedEvent> shapeSelectedEvent;

    public LayerShape build(final WiresBaseShape shape, ShapeFactory factory) {
        LayerShape layerShape = new LayerShape();
        Rectangle bounding = this.drawBoundingBox();
        ShapeGlyph glyph = factory.getGlyph();
        String name = shape instanceof OverridesFactoryDescription ? ((OverridesFactoryDescription)shape).getDescription() : factory.getShapeDescription();
        Text description = this.drawDescription(name);
        NodeMouseClickHandler handler = new NodeMouseClickHandler(){

            public void onNodeMouseClick(NodeMouseClickEvent nodeMouseClickEvent) {
                StencilLayerBuilder.this.shapeSelectedEvent.fire((Object)new ShapeSelectedEvent(shape));
            }
        };
        layerShape.addNodeMouseClickHandler(handler);
        layerShape.setBounding(bounding);
        layerShape.setDescription(description);
        layerShape.setGroup(this.scaleGlyph(glyph));
        return layerShape;
    }

    private Group scaleGlyph(ShapeGlyph glyph) {
        double sx = 25.0 / glyph.getWidth();
        double sy = 25.0 / glyph.getHeight();
        Group group = glyph.getGroup();
        return (Group)((Group)((Group)group.setX(15.0)).setY(15.0)).setScale(sx, sy);
    }

    private Rectangle drawBoundingBox() {
        Rectangle boundingBox = new Rectangle(250.0, 30.0);
        ((Rectangle)((Rectangle)((Rectangle)boundingBox.setStrokeColor(ShapeFactoryUtil.RGB_STROKE_BOUNDING)).setStrokeWidth(1.0)).setFillColor(ShapeFactoryUtil.RGB_FILL_BOUNDING)).setDraggable(false);
        return boundingBox;
    }

    private Text drawDescription(String description) {
        Text text = new Text(description, "oblique normal", 10.0);
        text.setFillColor(ShapeFactoryUtil.RGB_TEXT_DESCRIPTION);
        text.setTextBaseLine(TextBaseLine.MIDDLE);
        text.setX(40.0);
        text.setY(15.0);
        return text;
    }
}

