/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.client.factories;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.Shape;
import org.uberfire.ext.wires.core.api.factories.FactoryHelper;
import org.uberfire.ext.wires.core.api.factories.ShapeDragProxy;
import org.uberfire.ext.wires.core.api.factories.ShapeDragProxyCompleteCallback;
import org.uberfire.ext.wires.core.api.factories.ShapeDragProxyPreviewCallback;
import org.uberfire.ext.wires.core.api.factories.ShapeFactory;
import org.uberfire.ext.wires.core.api.factories.ShapeGlyph;

public abstract class AbstractBaseFactory<T extends Shape<T>>
implements ShapeFactory<T> {
    public ShapeGlyph getGlyph() {
        T shape = this.makeShape();
        final Group group = new Group();
        group.add(shape);
        return new ShapeGlyph(){

            public Group getGroup() {
                return group;
            }

            public double getWidth() {
                return AbstractBaseFactory.this.getWidth();
            }

            public double getHeight() {
                return AbstractBaseFactory.this.getHeight();
            }
        };
    }

    public ShapeDragProxy getDragProxy(FactoryHelper helper, final ShapeDragProxyPreviewCallback dragPreviewCallback, final ShapeDragProxyCompleteCallback dragEndCallBack) {
        T shape = this.makeShape();
        final Group group = new Group();
        group.add(shape);
        return new ShapeDragProxy(){

            public Group getDragGroup() {
                return group;
            }

            public void onDragPreview(double x, double y) {
                dragPreviewCallback.callback(x, y);
            }

            public void onDragComplete(double x, double y) {
                dragEndCallBack.callback(x, y);
            }

            public double getWidth() {
                return AbstractBaseFactory.this.getWidth();
            }

            public double getHeight() {
                return AbstractBaseFactory.this.getHeight();
            }
        };
    }

    protected abstract T makeShape();

    protected abstract double getWidth();

    protected abstract double getHeight();
}

