/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.client.palette;

import com.ait.lienzo.client.core.event.NodeMouseDownEvent;
import com.ait.lienzo.client.core.event.NodeMouseDownHandler;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.core.shape.Rectangle;
import com.ait.lienzo.client.core.shape.Text;
import com.ait.lienzo.client.widget.LienzoPanel;
import com.ait.lienzo.shared.core.types.TextBaseLine;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.uberfire.ext.wires.core.api.events.ShapeDragCompleteEvent;
import org.uberfire.ext.wires.core.api.events.ShapeDragPreviewEvent;
import org.uberfire.ext.wires.core.api.factories.FactoryHelper;
import org.uberfire.ext.wires.core.api.factories.ShapeDragProxy;
import org.uberfire.ext.wires.core.api.factories.ShapeDragProxyCompleteCallback;
import org.uberfire.ext.wires.core.api.factories.ShapeDragProxyPreviewCallback;
import org.uberfire.ext.wires.core.api.factories.ShapeFactory;
import org.uberfire.ext.wires.core.api.factories.ShapeGlyph;
import org.uberfire.ext.wires.core.api.shapes.WiresBaseShape;
import org.uberfire.ext.wires.core.client.palette.PaletteShape;
import org.uberfire.ext.wires.core.client.util.ShapeFactoryUtil;

@ApplicationScoped
public class StencilPaletteBuilder {
    private static final int ZINDEX = Integer.MAX_VALUE;
    private static final double GLYPH_WIDTH = 65.0;
    private static final double GLYPH_HEIGHT = 65.0;
    @Inject
    private Event<ShapeDragCompleteEvent> shapeDragCompleteEvent;
    @Inject
    private Event<ShapeDragPreviewEvent> shapeDragPreviewEvent;

    public PaletteShape build(LienzoPanel dragProxyParentPanel, final FactoryHelper helper, final ShapeFactory factory) {
        PaletteShape paletteShape = new PaletteShape();
        ShapeGlyph glyph = this.drawGlyph(factory, helper);
        Text description = this.drawDescription(factory, helper);
        Rectangle bounding = this.drawBoundingBox(factory, helper);
        ShapeDragProxyCompleteCallback dragCompleteCallback = new ShapeDragProxyCompleteCallback(){

            public void callback(double x, double y) {
                StencilPaletteBuilder.this.shapeDragCompleteEvent.fire((Object)new ShapeDragCompleteEvent(factory.getShape(helper), x, y));
            }
        };
        final WiresBaseShape shape = factory.getShape(helper);
        ShapeDragProxyPreviewCallback dragPreviewCallback = new ShapeDragProxyPreviewCallback(){

            public void callback(double x, double y) {
                StencilPaletteBuilder.this.shapeDragPreviewEvent.fire((Object)new ShapeDragPreviewEvent(shape, x, y));
            }
        };
        ShapeDragProxy dragProxy = factory.getDragProxy(helper, dragPreviewCallback, dragCompleteCallback);
        this.addDragHandlers(dragProxyParentPanel, dragProxy, paletteShape);
        paletteShape.setBounding(bounding);
        paletteShape.setGroup(this.scaleGlyph(glyph));
        paletteShape.setDescription(description);
        return paletteShape;
    }

    protected ShapeGlyph drawGlyph(ShapeFactory factory, FactoryHelper helper) {
        return factory.getGlyph();
    }

    protected Group scaleGlyph(ShapeGlyph glyph) {
        double sx = 65.0 / glyph.getWidth();
        double sy = 65.0 / glyph.getHeight();
        Group group = glyph.getGroup();
        return (Group)((Group)((Group)group.setX(37.0)).setY(37.0)).setScale(sx, sy);
    }

    protected Text drawDescription(ShapeFactory factory, FactoryHelper helper) {
        Text text = new Text(factory.getShapeDescription(), "oblique normal", 10.0);
        text.setFillColor(ShapeFactoryUtil.RGB_TEXT_DESCRIPTION);
        text.setTextBaseLine(TextBaseLine.MIDDLE);
        text.setX(5.0);
        text.setY(85.0);
        return text;
    }

    protected Rectangle drawBoundingBox(ShapeFactory factory, FactoryHelper helper) {
        Rectangle boundingBox = new Rectangle(75.0, 100.0);
        ((Rectangle)((Rectangle)((Rectangle)boundingBox.setStrokeColor(ShapeFactoryUtil.RGB_STROKE_BOUNDING)).setStrokeWidth(1.0)).setFillColor(ShapeFactoryUtil.RGB_FILL_BOUNDING)).setDraggable(false);
        return boundingBox;
    }

    private void addDragHandlers(LienzoPanel dragProxyParentPanel, ShapeDragProxy proxy, Group shape) {
        shape.addNodeMouseDownHandler(this.getShapeDragStartHandler(dragProxyParentPanel, proxy));
    }

    private NodeMouseDownHandler getShapeDragStartHandler(final LienzoPanel dragProxyParentPanel, final ShapeDragProxy proxy) {
        return new NodeMouseDownHandler(){

            public void onNodeMouseDown(NodeMouseDownEvent event) {
                double proxyWidth = proxy.getWidth();
                double proxyHeight = proxy.getHeight();
                Group dragShape = proxy.getDragGroup();
                dragShape.setX(proxyWidth / 2.0);
                dragShape.setY(proxyHeight / 2.0);
                LienzoPanel dragProxyPanel = new LienzoPanel((int)proxyWidth, (int)proxyHeight);
                Layer dragProxyLayer = new Layer();
                dragProxyLayer.add((IPrimitive)dragShape);
                dragProxyPanel.add(dragProxyLayer);
                dragProxyLayer.batch();
                StencilPaletteBuilder.this.setDragProxyPosition(dragProxyParentPanel, dragProxyPanel, proxyWidth, proxyHeight, event);
                StencilPaletteBuilder.this.attachDragProxyHandlers(dragProxyPanel, proxy);
                RootPanel.get().add((Widget)dragProxyPanel);
            }
        };
    }

    private void setDragProxyPosition(LienzoPanel dragProxyParentPanel, LienzoPanel dragProxyPanel, double proxyWidth, double proxyHeight, NodeMouseDownEvent event) {
        Style style = dragProxyPanel.getElement().getStyle();
        style.setPosition(Style.Position.ABSOLUTE);
        style.setLeft((double)(dragProxyParentPanel.getAbsoluteLeft() + event.getX()) - proxyWidth / 2.0, Style.Unit.PX);
        style.setTop((double)(dragProxyParentPanel.getAbsoluteTop() + event.getY()) - proxyHeight / 2.0, Style.Unit.PX);
        style.setZIndex(Integer.MAX_VALUE);
    }

    private void attachDragProxyHandlers(final LienzoPanel floatingPanel, final ShapeDragProxy proxy) {
        HandlerRegistration[] handlerRegs;
        final Style style = floatingPanel.getElement().getStyle();
        handlerRegs = new HandlerRegistration[]{RootPanel.get().addDomHandler((EventHandler)new MouseMoveHandler(){

            public void onMouseMove(MouseMoveEvent mouseMoveEvent) {
                style.setLeft((double)(mouseMoveEvent.getX() - floatingPanel.getWidth() / 2), Style.Unit.PX);
                style.setTop((double)(mouseMoveEvent.getY() - floatingPanel.getHeight() / 2), Style.Unit.PX);
                proxy.onDragPreview((double)mouseMoveEvent.getX(), (double)mouseMoveEvent.getY());
            }
        }, MouseMoveEvent.getType()), RootPanel.get().addDomHandler((EventHandler)new MouseUpHandler(){

            public void onMouseUp(MouseUpEvent mouseUpEvent) {
                handlerRegs[0].removeHandler();
                handlerRegs[1].removeHandler();
                RootPanel.get().remove((Widget)floatingPanel);
                proxy.onDragComplete((double)mouseUpEvent.getX(), (double)mouseUpEvent.getY());
            }
        }, MouseUpEvent.getType())};
    }
}

