/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.model.impl;

import java.util.ArrayList;
import java.util.List;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;

public class BaseGridDataSelectionsManager {
    private final GridData gridData;

    public BaseGridDataSelectionsManager(GridData gridData) {
        this.gridData = gridData;
    }

    public void onMerge(boolean isMerged) {
        if (isMerged) {
            List<GridData.SelectedCell> selectedCells = this.gridData.getSelectedCells();
            ArrayList<GridData.SelectedCell> cloneSelectedCells = new ArrayList<GridData.SelectedCell>(selectedCells);
            this.gridData.clearSelections();
            for (GridData.SelectedCell cell : cloneSelectedCells) {
                this.gridData.selectCells(cell.getRowIndex(), this.findUiColumnIndex(cell.getColumnIndex()), 1, 1);
            }
        }
    }

    private int findUiColumnIndex(int modelColumnIndex) {
        List<GridColumn<?>> columns = this.gridData.getColumns();
        for (int uiColumnIndex = 0; uiColumnIndex < columns.size(); ++uiColumnIndex) {
            GridColumn<?> c = columns.get(uiColumnIndex);
            if (c.getIndex() != modelColumnIndex) continue;
            return uiColumnIndex;
        }
        throw new IllegalStateException("Column was not found!");
    }

    public void onDeleteColumn(int index) {
        List<GridData.SelectedCell> selectedCells = this.gridData.getSelectedCells();
        ArrayList<GridData.SelectedCell> selectedCellsToRemove = new ArrayList<GridData.SelectedCell>();
        ArrayList<GridData.SelectedCell> selectedCellsToUpdate = new ArrayList<GridData.SelectedCell>();
        for (GridData.SelectedCell sc : selectedCells) {
            if (sc.getColumnIndex() == index) {
                selectedCellsToRemove.add(sc);
                continue;
            }
            if (sc.getColumnIndex() <= index) continue;
            selectedCellsToUpdate.add(sc);
        }
        selectedCells.removeAll(selectedCellsToRemove);
        selectedCells.removeAll(selectedCellsToUpdate);
        for (GridData.SelectedCell sc : selectedCellsToUpdate) {
            selectedCells.add(new GridData.SelectedCell(sc.getRowIndex(), sc.getColumnIndex() - 1));
        }
    }

    public void onInsertRow(int rowIndex) {
        List<GridData.SelectedCell> selectedCells = this.gridData.getSelectedCells();
        ArrayList<GridData.SelectedCell> selectedCellsToUpdate = new ArrayList<GridData.SelectedCell>();
        for (GridData.SelectedCell sc : selectedCells) {
            if (sc.getRowIndex() < rowIndex) continue;
            selectedCellsToUpdate.add(sc);
        }
        selectedCells.removeAll(selectedCellsToUpdate);
        for (GridData.SelectedCell sc : selectedCellsToUpdate) {
            selectedCells.add(new GridData.SelectedCell(sc.getRowIndex() + 1, sc.getColumnIndex()));
        }
    }

    public void onDeleteRow(GridData.Range range) {
        int minRowIndex = range.getMinRowIndex();
        int maxRowIndex = range.getMaxRowIndex();
        List<GridData.SelectedCell> selectedCells = this.gridData.getSelectedCells();
        ArrayList<GridData.SelectedCell> selectedCellsToRemove = new ArrayList<GridData.SelectedCell>();
        ArrayList<GridData.SelectedCell> selectedCellsToUpdate = new ArrayList<GridData.SelectedCell>();
        for (GridData.SelectedCell sc : selectedCells) {
            if (sc.getRowIndex() >= minRowIndex && sc.getRowIndex() <= maxRowIndex) {
                selectedCellsToRemove.add(sc);
                continue;
            }
            if (sc.getRowIndex() <= maxRowIndex) continue;
            selectedCellsToUpdate.add(sc);
        }
        selectedCells.removeAll(selectedCellsToRemove);
        selectedCells.removeAll(selectedCellsToUpdate);
        for (GridData.SelectedCell sc : selectedCellsToUpdate) {
            selectedCells.add(new GridData.SelectedCell(sc.getRowIndex() - 1, sc.getColumnIndex()));
        }
    }

    public GridData.Range onSelectCell(int rowIndex, int columnIndex) {
        if (this.gridData.isMerged()) {
            return this.selectCellMerged(rowIndex, columnIndex);
        }
        this.selectCellNotMerged(rowIndex, columnIndex);
        return new GridData.Range(rowIndex);
    }

    public GridData.Range onSelectCells(int rowIndex, int columnIndex, int width, int height) {
        if (!this.gridData.isMerged()) {
            this.selectCellsNotMerged(rowIndex, columnIndex, width, height);
            return new GridData.Range(rowIndex);
        }
        int minRowIndex = rowIndex;
        int maxRowIndex = rowIndex + height - 1;
        List<GridColumn<?>> columns = this.gridData.getColumns();
        for (int ci = columnIndex; ci < columnIndex + width; ++ci) {
            int _columnIndex = columns.get(ci).getIndex();
            minRowIndex = Math.min(minRowIndex, this.findMinRowIndex(minRowIndex, _columnIndex));
            maxRowIndex = Math.max(maxRowIndex, this.findMaxRowIndex(maxRowIndex, _columnIndex));
        }
        this.selectCellsNotMerged(minRowIndex, columnIndex, width, maxRowIndex - minRowIndex + 1);
        return new GridData.Range(minRowIndex, maxRowIndex);
    }

    private GridData.Range selectCellMerged(int rowIndex, int columnIndex) {
        List<GridColumn<?>> columns = this.gridData.getColumns();
        int _columnIndex = columns.get(columnIndex).getIndex();
        int minRowIndex = this.findMinRowIndex(rowIndex, _columnIndex);
        int maxRowIndex = this.findMaxRowIndex(rowIndex, _columnIndex);
        this.selectCellsNotMerged(minRowIndex, columnIndex, 1, maxRowIndex - minRowIndex + 1);
        return new GridData.Range(minRowIndex, maxRowIndex);
    }

    private GridData.Range selectCellNotMerged(int rowIndex, int columnIndex) {
        List<GridRow> rows = this.gridData.getRows();
        List<GridColumn<?>> columns = this.gridData.getColumns();
        List<GridData.SelectedCell> selectedCells = this.gridData.getSelectedCells();
        GridData.Range range = new GridData.Range(rowIndex);
        if (rowIndex < 0 || rowIndex > rows.size() - 1) {
            return range;
        }
        if (columnIndex < 0 || columnIndex > columns.size() - 1) {
            return range;
        }
        int _columnIndex = columns.get(columnIndex).getIndex();
        GridData.SelectedCell selectedCell = new GridData.SelectedCell(rowIndex, _columnIndex);
        if (!selectedCells.contains(selectedCell)) {
            selectedCells.add(selectedCell);
        }
        return range;
    }

    private GridData.Range selectCellsNotMerged(int rowIndex, int columnIndex, int width, int height) {
        List<GridRow> rows = this.gridData.getRows();
        List<GridColumn<?>> columns = this.gridData.getColumns();
        List<GridData.SelectedCell> selectedCells = this.gridData.getSelectedCells();
        GridData.Range range = new GridData.Range(rowIndex);
        if (rowIndex < 0 || rowIndex > rows.size() - 1) {
            return range;
        }
        if (columnIndex < 0 || columnIndex > columns.size() - 1) {
            return range;
        }
        if (width < 1) {
            return range;
        }
        if (height < 1) {
            return range;
        }
        for (int ri = rowIndex; ri < rowIndex + height; ++ri) {
            for (int ci = columnIndex; ci < columnIndex + width; ++ci) {
                int _columnIndex = columns.get(ci).getIndex();
                GridData.SelectedCell selectedCell = new GridData.SelectedCell(ri, _columnIndex);
                if (selectedCells.contains(selectedCell)) continue;
                selectedCells.add(selectedCell);
            }
        }
        return new GridData.Range(rowIndex, rowIndex + height - 1);
    }

    private int findMinRowIndex(int rowIndex, int columnIndex) {
        int minRowIndex;
        boolean foundTopSplitMarker;
        GridRow currentRow = this.gridData.getRow(rowIndex);
        GridCell<?> currentRowCell = currentRow.getCells().get(columnIndex);
        boolean bl = foundTopSplitMarker = currentRowCell != null && currentRowCell.getMergedCellCount() > 0;
        for (minRowIndex = rowIndex; minRowIndex > 0; --minRowIndex) {
            GridRow previousRow = this.gridData.getRow(minRowIndex - 1);
            GridCell<?> previousRowCell = previousRow.getCells().get(columnIndex);
            if (previousRow.isCollapsed() && currentRow.isCollapsed()) continue;
            if (previousRowCell == null || previousRowCell.isCollapsed() && foundTopSplitMarker || !previousRowCell.equals(currentRowCell)) break;
            if (previousRowCell.getMergedCellCount() <= 0) continue;
            foundTopSplitMarker = true;
        }
        return minRowIndex;
    }

    private int findMaxRowIndex(int rowIndex, int columnIndex) {
        int maxRowIndex;
        GridRow currentRow = this.gridData.getRow(rowIndex);
        GridCell<?> currentRowCell = currentRow.getCells().get(columnIndex);
        boolean foundBottomSplitMarker = false;
        for (maxRowIndex = rowIndex + 1; maxRowIndex < this.gridData.getRowCount(); ++maxRowIndex) {
            GridRow nextRow = this.gridData.getRow(maxRowIndex);
            GridCell<?> nextRowCell = nextRow.getCells().get(columnIndex);
            if (nextRow.isCollapsed()) continue;
            if (nextRowCell == null) break;
            if (nextRowCell.isCollapsed() && foundBottomSplitMarker) {
                --maxRowIndex;
                break;
            }
            if (!nextRowCell.equals(currentRowCell)) break;
            if (nextRowCell.getMergedCellCount() <= 0) continue;
            foundBottomSplitMarker = true;
        }
        return maxRowIndex - 1;
    }

    public void onMoveRows(List<GridRow> rowsMoved, GridData.Range oldBlockExtent) {
        block13: {
            ArrayList<GridData.SelectedCell> selectedCellsToUpdate;
            ArrayList<GridData.SelectedCell> selectedCellsToMoveDown;
            ArrayList<GridData.SelectedCell> selectedCellsToMoveUp;
            List<GridData.SelectedCell> selectedCells;
            int newBlockEnd;
            int newBlockStart;
            int oldBlockEnd;
            int oldBlockStart;
            block12: {
                List<GridRow> rows = this.gridData.getRows();
                oldBlockStart = oldBlockExtent.getMinRowIndex();
                oldBlockEnd = oldBlockExtent.getMaxRowIndex();
                newBlockStart = rows.indexOf(rowsMoved.get(0));
                newBlockEnd = rows.indexOf(rowsMoved.get(rowsMoved.size() - 1));
                selectedCells = this.gridData.getSelectedCells();
                selectedCellsToMoveUp = new ArrayList<GridData.SelectedCell>();
                selectedCellsToMoveDown = new ArrayList<GridData.SelectedCell>();
                selectedCellsToUpdate = new ArrayList<GridData.SelectedCell>();
                if (newBlockStart >= oldBlockStart) break block12;
                for (GridData.SelectedCell sc : selectedCells) {
                    if (sc.getRowIndex() >= oldBlockStart && sc.getRowIndex() <= oldBlockEnd) {
                        selectedCellsToMoveUp.add(sc);
                        continue;
                    }
                    if (sc.getRowIndex() >= newBlockStart && sc.getRowIndex() <= newBlockEnd) {
                        selectedCellsToMoveDown.add(sc);
                        continue;
                    }
                    if (sc.getRowIndex() <= newBlockEnd || sc.getRowIndex() >= oldBlockStart) continue;
                    selectedCellsToUpdate.add(sc);
                }
                selectedCells.removeAll(selectedCellsToMoveUp);
                selectedCells.removeAll(selectedCellsToMoveDown);
                selectedCells.removeAll(selectedCellsToUpdate);
                for (GridData.SelectedCell sc : selectedCellsToMoveUp) {
                    selectedCells.add(new GridData.SelectedCell(sc.getRowIndex() - (oldBlockStart - newBlockStart), sc.getColumnIndex()));
                }
                for (GridData.SelectedCell sc : selectedCellsToMoveDown) {
                    selectedCells.add(new GridData.SelectedCell(sc.getRowIndex() + (oldBlockEnd - oldBlockStart) + 1, sc.getColumnIndex()));
                }
                for (GridData.SelectedCell sc : selectedCellsToUpdate) {
                    selectedCells.add(new GridData.SelectedCell(sc.getRowIndex() + (oldBlockEnd - oldBlockStart) + 1, sc.getColumnIndex()));
                }
                break block13;
            }
            if (newBlockStart <= oldBlockStart) break block13;
            for (GridData.SelectedCell sc : selectedCells) {
                if (sc.getRowIndex() >= oldBlockStart && sc.getRowIndex() <= oldBlockEnd) {
                    selectedCellsToMoveDown.add(sc);
                    continue;
                }
                if (sc.getRowIndex() >= newBlockStart && sc.getRowIndex() <= newBlockEnd) {
                    selectedCellsToMoveUp.add(sc);
                    continue;
                }
                if (sc.getRowIndex() <= oldBlockEnd || sc.getRowIndex() >= newBlockStart) continue;
                selectedCellsToUpdate.add(sc);
            }
            selectedCells.removeAll(selectedCellsToMoveUp);
            selectedCells.removeAll(selectedCellsToMoveDown);
            selectedCells.removeAll(selectedCellsToUpdate);
            for (GridData.SelectedCell sc : selectedCellsToMoveUp) {
                selectedCells.add(new GridData.SelectedCell(sc.getRowIndex() - (oldBlockEnd - oldBlockStart) - 1, sc.getColumnIndex()));
            }
            for (GridData.SelectedCell sc : selectedCellsToMoveDown) {
                selectedCells.add(new GridData.SelectedCell(sc.getRowIndex() + (newBlockStart - oldBlockStart), sc.getColumnIndex()));
            }
            for (GridData.SelectedCell sc : selectedCellsToUpdate) {
                selectedCells.add(new GridData.SelectedCell(sc.getRowIndex() - (newBlockEnd - newBlockStart) - 1, sc.getColumnIndex()));
            }
        }
    }
}

