/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.util;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.client.core.types.Transform;
import java.util.List;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;

public class CoordinateUtilities {
    public static Point2D convertDOMToGridCoordinate(GridWidget view, Point2D point) {
        Transform transform = view.getViewport().getTransform();
        if (transform == null) {
            transform = new Transform();
            view.getViewport().setTransform(transform);
        }
        transform = transform.copy().getInverse();
        Point2D p = new Point2D(point.getX(), point.getY());
        transform.transform(p, p);
        return p.add(view.getLocation().mul(-1.0));
    }

    public static GridData.SelectedCell getCell(GridWidget gridWidget, Point2D cp) {
        double headerMaxY;
        double cx = cp.getX();
        double cy = cp.getY();
        Group header = gridWidget.getHeader();
        GridData gridModel = gridWidget.getModel();
        GridRenderer renderer = gridWidget.getRenderer();
        BaseGridRendererHelper rendererHelper = gridWidget.getRendererHelper();
        double d = headerMaxY = header == null ? renderer.getHeaderHeight() : renderer.getHeaderHeight() + header.getY();
        if (cx < 0.0 || cx > gridWidget.getWidth()) {
            return null;
        }
        if (cy < headerMaxY || cy > gridWidget.getHeight()) {
            return null;
        }
        int uiRowIndex = 0;
        double offsetY = cy - renderer.getHeaderHeight();
        while (true) {
            GridRow gridRow;
            GridRow row = gridModel.getRow(uiRowIndex);
            if (!(gridRow.getHeight() < offsetY)) break;
            offsetY -= row.getHeight();
            ++uiRowIndex;
        }
        if (uiRowIndex < 0 || uiRowIndex > gridModel.getRowCount() - 1) {
            return null;
        }
        List<GridColumn<?>> columns = gridModel.getColumns();
        BaseGridRendererHelper.ColumnInformation ci = rendererHelper.getColumnInformation(cx);
        GridColumn<?> column = ci.getColumn();
        int uiColumnIndex = ci.getUiColumnIndex();
        if (column == null) {
            return null;
        }
        if (uiColumnIndex < 0 || uiColumnIndex > columns.size() - 1) {
            return null;
        }
        return new GridData.SelectedCell(uiRowIndex, uiColumnIndex);
    }
}

