/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.impl;

import com.ait.lienzo.client.core.event.NodeMouseDoubleClickEvent;
import com.ait.lienzo.client.core.event.NodeMouseDoubleClickHandler;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.types.Point2D;
import java.util.List;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.util.CoordinateUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;

public class BaseGridWidgetMouseDoubleClickHandler
implements NodeMouseDoubleClickHandler {
    protected GridData gridModel;
    protected GridWidget gridWidget;
    protected BaseGridRendererHelper rendererHelper;
    protected GridSelectionManager selectionManager;
    protected GridPinnedModeManager pinnedModeManager;
    protected GridRenderer renderer;

    public BaseGridWidgetMouseDoubleClickHandler(GridWidget gridWidget, GridSelectionManager selectionManager, GridPinnedModeManager pinnedModeManager, GridRenderer renderer) {
        this.gridWidget = gridWidget;
        this.gridModel = gridWidget.getModel();
        this.rendererHelper = gridWidget.getRendererHelper();
        this.selectionManager = selectionManager;
        this.pinnedModeManager = pinnedModeManager;
        this.renderer = renderer;
    }

    public void onNodeMouseDoubleClick(NodeMouseDoubleClickEvent event) {
        if (!this.gridWidget.isVisible()) {
            return;
        }
        if (!this.handleHeaderCellDoubleClick(event)) {
            this.handleBodyCellDoubleClick(event);
        }
    }

    boolean handleHeaderCellDoubleClick(NodeMouseDoubleClickEvent event) {
        double headerMaxY;
        Point2D ap = CoordinateUtilities.convertDOMToGridCoordinate(this.gridWidget, new Point2D((double)event.getX(), (double)event.getY()));
        double cx = ap.getX();
        double cy = ap.getY();
        Group header = this.gridWidget.getHeader();
        double headerRowsYOffset = this.getHeaderRowsYOffset();
        double headerMinY = header == null ? headerRowsYOffset : header.getY() + headerRowsYOffset;
        double d = headerMaxY = header == null ? this.renderer.getHeaderHeight() : this.renderer.getHeaderHeight() + header.getY();
        if (cx < 0.0 || cx > this.gridWidget.getWidth()) {
            return false;
        }
        if (cy < headerMinY || cy > headerMaxY) {
            return false;
        }
        if (!this.pinnedModeManager.isGridPinned()) {
            this.pinnedModeManager.enterPinnedMode(this.gridWidget, () -> {});
        } else {
            this.pinnedModeManager.exitPinnedMode(() -> {});
        }
        return true;
    }

    private double getHeaderRowsYOffset() {
        GridData model = this.gridWidget.getModel();
        int headerRowCount = model.getHeaderRowCount();
        double headerHeight = this.renderer.getHeaderHeight();
        double headerRowHeight = this.renderer.getHeaderRowHeight();
        double headerRowsHeight = headerRowHeight * (double)headerRowCount;
        double headerRowsYOffset = headerHeight - headerRowsHeight;
        return headerRowsYOffset;
    }

    boolean handleBodyCellDoubleClick(NodeMouseDoubleClickEvent event) {
        double headerMaxY;
        Point2D ap = CoordinateUtilities.convertDOMToGridCoordinate(this.gridWidget, new Point2D((double)event.getX(), (double)event.getY()));
        double cx = ap.getX();
        double cy = ap.getY();
        Group header = this.gridWidget.getHeader();
        double d = headerMaxY = header == null ? this.renderer.getHeaderHeight() : this.renderer.getHeaderHeight() + header.getY();
        if (cx < 0.0 || cx > this.gridWidget.getWidth()) {
            return false;
        }
        if (cy < headerMaxY || cy > this.gridWidget.getHeight()) {
            return false;
        }
        if (this.gridModel.getRowCount() == 0) {
            return false;
        }
        int uiRowIndex = 0;
        double offsetY = cy - this.renderer.getHeaderHeight();
        while (true) {
            GridRow gridRow;
            GridRow row = this.gridModel.getRow(uiRowIndex);
            if (!(gridRow.getHeight() < offsetY)) break;
            offsetY -= row.getHeight();
            ++uiRowIndex;
        }
        if (uiRowIndex < 0 || uiRowIndex > this.gridModel.getRowCount() - 1) {
            return false;
        }
        BaseGridRendererHelper.ColumnInformation ci = this.rendererHelper.getColumnInformation(cx);
        GridColumn<?> column = ci.getColumn();
        if (column == null) {
            return false;
        }
        int uiColumnIndex = ci.getUiColumnIndex();
        List<GridColumn<?>> columns = this.gridModel.getColumns();
        if (uiColumnIndex < 0 || uiColumnIndex > columns.size() - 1) {
            return false;
        }
        double offsetX = ci.getOffsetX();
        BaseGridRendererHelper.RenderingInformation renderingInformation = this.rendererHelper.getRenderingInformation();
        if (renderingInformation == null) {
            return false;
        }
        BaseGridRendererHelper.RenderingBlockInformation floatingBlockInformation = renderingInformation.getFloatingBlockInformation();
        double floatingX = floatingBlockInformation.getX();
        double floatingWidth = floatingBlockInformation.getWidth();
        double cellX = this.gridWidget.getX() + offsetX;
        double cellY = this.gridWidget.getY() + this.renderer.getHeaderHeight() + this.getRowOffset(uiRowIndex, uiColumnIndex);
        double cellHeight = this.getCellHeight(uiRowIndex, uiColumnIndex);
        double clipMinY = this.gridWidget.getY() + header.getY() + this.renderer.getHeaderHeight();
        double clipMinX = this.gridWidget.getX() + floatingX + floatingWidth;
        GridBodyCellRenderContext context = new GridBodyCellRenderContext(cellX, cellY, column.getWidth(), cellHeight, clipMinY, clipMinX, uiRowIndex, uiColumnIndex, floatingBlockInformation.getColumns().contains(column), this.gridWidget.getViewport().getTransform(), this.renderer);
        this.onDoubleClick(context);
        return true;
    }

    protected double getRowOffset(int uiRowIndex, int uiColumnIndex) {
        GridCell<?> cell = this.gridModel.getCell(uiRowIndex, uiColumnIndex);
        if (cell == null) {
            return this.rendererHelper.getRowOffset(uiRowIndex);
        }
        if (cell.getMergedCellCount() == 1) {
            return this.rendererHelper.getRowOffset(uiRowIndex);
        }
        if (cell.getMergedCellCount() > 1) {
            return this.rendererHelper.getRowOffset(uiRowIndex);
        }
        int _uiRowIndex = uiRowIndex;
        GridCell<?> _cell = cell;
        while (_cell.getMergedCellCount() == 0) {
            _cell = this.gridModel.getCell(--_uiRowIndex, uiColumnIndex);
        }
        return this.rendererHelper.getRowOffset(_uiRowIndex);
    }

    protected double getCellHeight(int uiRowIndex, int uiColumnIndex) {
        GridCell<?> cell = this.gridModel.getCell(uiRowIndex, uiColumnIndex);
        if (cell == null) {
            return this.gridModel.getRow(uiRowIndex).getHeight();
        }
        if (cell.getMergedCellCount() == 1) {
            return this.gridModel.getRow(uiRowIndex).getHeight();
        }
        if (cell.getMergedCellCount() > 1) {
            double height = 0.0;
            for (int i = uiRowIndex; i < uiRowIndex + cell.getMergedCellCount(); ++i) {
                height += this.gridModel.getRow(i).getHeight();
            }
            return height;
        }
        int _uiRowIndex = uiRowIndex;
        GridCell<?> _cell = cell;
        while (_cell.getMergedCellCount() == 0) {
            _cell = this.gridModel.getCell(--_uiRowIndex, uiColumnIndex);
        }
        double height = 0.0;
        for (int i = _uiRowIndex; i < _uiRowIndex + _cell.getMergedCellCount(); ++i) {
            height += this.gridModel.getRow(i).getHeight();
        }
        return height;
    }

    protected void onDoubleClick(GridBodyCellRenderContext context) {
        final int uiRowIndex = context.getRowIndex();
        final int uiColumnIndex = context.getColumnIndex();
        GridCell<?> cell = this.gridModel.getCell(uiRowIndex, uiColumnIndex);
        GridColumn<?> column = this.gridModel.getColumns().get(uiColumnIndex);
        column.edit(cell, context, new Callback<GridCellValue<?>>(){

            public void callback(GridCellValue<?> value) {
                BaseGridWidgetMouseDoubleClickHandler.this.gridModel.setCell(uiRowIndex, uiColumnIndex, value);
                BaseGridWidgetMouseDoubleClickHandler.this.gridWidget.getLayer().batch();
            }
        });
    }
}

