/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.impl;

import com.ait.lienzo.client.core.event.NodeMouseClickEvent;
import com.ait.lienzo.client.core.event.NodeMouseClickHandler;
import com.ait.lienzo.client.core.types.Point2D;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.util.CoordinateUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.CellSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.impl.CellRangeSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridSelectionManager;

public class GridCellSelectorMouseClickHandler
implements NodeMouseClickHandler {
    protected GridData gridModel;
    protected GridWidget gridWidget;
    protected BaseGridRendererHelper rendererHelper;
    protected GridSelectionManager selectionManager;
    protected GridRenderer renderer;

    public GridCellSelectorMouseClickHandler(GridWidget gridWidget, GridSelectionManager selectionManager, GridRenderer renderer) {
        this.gridWidget = gridWidget;
        this.gridModel = gridWidget.getModel();
        this.rendererHelper = gridWidget.getRendererHelper();
        this.selectionManager = selectionManager;
        this.renderer = renderer;
    }

    public void onNodeMouseClick(NodeMouseClickEvent event) {
        if (!this.gridWidget.isVisible()) {
            return;
        }
        this.handleBodyCellClick(event);
    }

    void handleBodyCellClick(NodeMouseClickEvent event) {
        int uiColumnIndex;
        Point2D ap = CoordinateUtilities.convertDOMToGridCoordinate(this.gridWidget, new Point2D((double)event.getX(), (double)event.getY()));
        GridData.SelectedCell sc = CoordinateUtilities.getCell(this.gridWidget, ap);
        if (sc == null) {
            return;
        }
        int uiRowIndex = sc.getRowIndex();
        GridCell<?> cell = this.gridModel.getCell(uiRowIndex, uiColumnIndex = sc.getColumnIndex());
        CellSelectionManager selectionManager = cell == null ? CellRangeSelectionManager.INSTANCE : cell.getSelectionManager();
        if (selectionManager == null) {
            return;
        }
        if (selectionManager.handleSelection(this.gridModel, uiRowIndex, uiColumnIndex, event.isShiftKeyDown(), event.isControlKeyDown())) {
            this.gridWidget.getLayer().batch();
        }
    }
}

