/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.columns.impl;

import com.ait.lienzo.client.core.shape.BoundingBoxPathClipper;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPathClipper;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.MultiPath;
import com.ait.lienzo.client.core.shape.Text;
import com.ait.lienzo.client.core.types.BoundingBox;
import java.util.List;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyColumnRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridHeaderColumnRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.columns.GridColumnRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.columns.impl.ColumnRenderingStrategyFlattened;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.columns.impl.ColumnRenderingStrategyMerged;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.themes.GridRendererTheme;

public abstract class BaseGridColumnRenderer<T>
implements GridColumnRenderer<T> {
    private ColumnRenderingStrategyMerged renderColumnMerged = new ColumnRenderingStrategyMerged();
    private ColumnRenderingStrategyFlattened renderColumnFlattened = new ColumnRenderingStrategyFlattened();

    @Override
    public Group renderHeader(List<GridColumn.HeaderMetaData> headerMetaData, GridHeaderColumnRenderContext context, BaseGridRendererHelper.RenderingInformation renderingInformation) {
        Group g = new Group();
        GridData model = context.getModel();
        GridRenderer renderer = context.getRenderer();
        GridRendererTheme theme = renderer.getTheme();
        double headerRowsHeight = renderingInformation.getHeaderRowsHeight();
        double headerRowsYOffset = renderingInformation.getHeaderRowsYOffset();
        double rowHeight = headerRowsHeight / (double)headerMetaData.size();
        List<GridColumn<?>> allBlockColumns = context.getAllColumns();
        List<GridColumn<?>> visibleBlockColumns = context.getBlockColumns();
        int headerStartColumnIndex = allBlockColumns.indexOf(visibleBlockColumns.get(0));
        int headerColumnIndex = allBlockColumns.indexOf(visibleBlockColumns.get(context.getColumnIndex()));
        GridColumn<?> column = visibleBlockColumns.get(context.getColumnIndex());
        MultiPath headerGrid = (MultiPath)theme.getHeaderGridLine().setY(headerRowsYOffset);
        for (int headerRowIndex = 0; headerRowIndex < headerMetaData.size(); ++headerRowIndex) {
            boolean skip;
            int blockStartColumnIndex = this.getBlockStartColumnIndex(allBlockColumns, headerMetaData.get(headerRowIndex), headerRowIndex, headerColumnIndex);
            int blockEndColumnIndex = this.getBlockEndColumnIndex(allBlockColumns, headerMetaData.get(headerRowIndex), headerRowIndex, headerColumnIndex);
            if (headerColumnIndex < model.getColumnCount() - 1 && blockEndColumnIndex == headerColumnIndex) {
                double hx = column.getWidth();
                headerGrid.M(hx + 0.5, (double)headerRowIndex * rowHeight).L(hx + 0.5, (double)(headerRowIndex + 1) * rowHeight);
            }
            if (blockStartColumnIndex >= headerStartColumnIndex) {
                skip = headerColumnIndex > blockStartColumnIndex;
            } else {
                boolean bl = skip = headerColumnIndex > headerStartColumnIndex;
            }
            if (skip) continue;
            double offsetX = this.getBlockOffset(allBlockColumns, blockStartColumnIndex, headerColumnIndex);
            double blockWidth = this.getBlockWidth(allBlockColumns, blockStartColumnIndex, blockEndColumnIndex);
            String title = headerMetaData.get(headerRowIndex).getTitle();
            Group headerGroup = new Group();
            Text t = (Text)((Text)((Text)theme.getHeaderText().setText(title).setListening(false)).setX(blockWidth / 2.0)).setY(rowHeight / 2.0);
            headerGroup.add((IPrimitive)t);
            BoundingBox bb = new BoundingBox(0.0, 0.0, blockWidth, rowHeight);
            BoundingBoxPathClipper clipper = new BoundingBoxPathClipper(bb);
            ((Group)((Group)headerGroup.setX(offsetX)).setY(headerRowsYOffset + (double)headerRowIndex * rowHeight)).setPathClipper((IPathClipper)clipper);
            clipper.setActive(true);
            g.add((IPrimitive)headerGroup);
            if (headerRowIndex <= 0) continue;
            headerGrid.M(offsetX, (double)headerRowIndex * rowHeight + 0.5).L(offsetX + blockWidth, (double)headerRowIndex * rowHeight + 0.5);
        }
        g.add((IPrimitive)headerGrid);
        return g;
    }

    private int getBlockStartColumnIndex(List<GridColumn<?>> allColumns, GridColumn.HeaderMetaData headerMetaData, int headerRowIndex, int headerColumnIndex) {
        GridColumn<?> candidateColumn;
        List<GridColumn.HeaderMetaData> candidateHeaderMetaData;
        int candidateHeaderColumnIndex = headerColumnIndex;
        if (candidateHeaderColumnIndex == 0) {
            return candidateHeaderColumnIndex;
        }
        while (candidateHeaderColumnIndex > 0 && (candidateHeaderMetaData = (candidateColumn = allColumns.get(candidateHeaderColumnIndex - 1)).getHeaderMetaData()).size() - 1 >= headerRowIndex && candidateHeaderMetaData.get(headerRowIndex).equals(headerMetaData)) {
            --candidateHeaderColumnIndex;
        }
        return candidateHeaderColumnIndex;
    }

    private int getBlockEndColumnIndex(List<GridColumn<?>> allColumns, GridColumn.HeaderMetaData headerMetaData, int headerRowIndex, int headerColumnIndex) {
        GridColumn<?> candidateColumn;
        List<GridColumn.HeaderMetaData> candidateHeaderMetaData;
        int candidateHeaderColumnIndex = headerColumnIndex;
        if (candidateHeaderColumnIndex == allColumns.size() - 1) {
            return candidateHeaderColumnIndex;
        }
        while (candidateHeaderColumnIndex < allColumns.size() - 1 && (candidateHeaderMetaData = (candidateColumn = allColumns.get(candidateHeaderColumnIndex + 1)).getHeaderMetaData()).size() - 1 >= headerRowIndex && candidateHeaderMetaData.get(headerRowIndex).equals(headerMetaData)) {
            ++candidateHeaderColumnIndex;
        }
        return candidateHeaderColumnIndex;
    }

    private double getBlockOffset(List<GridColumn<?>> allColumns, int blockStartColumnIndex, int headerColumnIndex) {
        double blockOffset = 0.0;
        for (int blockColumnIndex = blockStartColumnIndex; blockColumnIndex < headerColumnIndex; ++blockColumnIndex) {
            GridColumn<?> column = allColumns.get(blockColumnIndex);
            if (!column.isVisible()) continue;
            blockOffset -= column.getWidth();
        }
        return blockOffset;
    }

    private double getBlockWidth(List<GridColumn<?>> allColumns, int blockStartColumnIndex, int blockEndColumnIndex) {
        double blockWidth = 0.0;
        for (int blockColumnIndex = blockStartColumnIndex; blockColumnIndex <= blockEndColumnIndex; ++blockColumnIndex) {
            GridColumn<?> column = allColumns.get(blockColumnIndex);
            if (!column.isVisible()) continue;
            blockWidth += column.getWidth();
        }
        return blockWidth;
    }

    @Override
    public Group renderColumn(GridColumn<?> column, GridBodyColumnRenderContext context, BaseGridRendererHelper rendererHelper, BaseGridRendererHelper.RenderingInformation renderingInformation) {
        if (context.getModel().isMerged()) {
            return this.renderColumnMerged.render(column, context, rendererHelper, renderingInformation);
        }
        return this.renderColumnFlattened.render(column, context, rendererHelper, renderingInformation);
    }
}

