/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.selections.impl;

import java.util.ArrayList;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.CellSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.impl.BaseCellSelectionManager;

public class RowSelectionManager
extends BaseCellSelectionManager {
    public static CellSelectionManager INSTANCE = new RowSelectionManager();

    @Override
    public boolean handleSelection(GridData model, int uiRowIndex, int uiColumnIndex, boolean isShiftKeyDown, boolean isControlKeyDown) {
        GridData.SelectedCell selectedCellsOrigin = model.getSelectedCellsOrigin();
        ArrayList<GridData.SelectedCell> originalSelections = new ArrayList<GridData.SelectedCell>(model.getSelectedCells());
        if (!isControlKeyDown) {
            model.clearSelections();
        }
        if (isShiftKeyDown) {
            if (selectedCellsOrigin == null) {
                this.selectRow(model, uiRowIndex);
            } else {
                model.selectCell(selectedCellsOrigin.getRowIndex(), selectedCellsOrigin.getColumnIndex());
                int uiOriginRowIndex = selectedCellsOrigin.getRowIndex();
                this.selectRows(model, uiRowIndex > uiOriginRowIndex ? uiOriginRowIndex : uiRowIndex, Math.abs(uiRowIndex - uiOriginRowIndex) + 1);
            }
        } else {
            this.selectRow(model, uiRowIndex);
        }
        return this.hasSelectionChanged(model.getSelectedCells(), originalSelections);
    }

    private void selectRow(GridData model, int uiRowIndex) {
        model.selectCells(uiRowIndex, 0, model.getColumnCount(), 1);
    }

    private void selectRows(GridData model, int uiRowIndex, int height) {
        model.selectCells(uiRowIndex, 0, model.getColumnCount(), height);
    }
}

