/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.model.impl;

import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.CellSelectionStrategy;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.impl.RangeSelectionStrategy;

public class BaseGridCell<T>
implements GridCell<T> {
    private int collapseLevel = 0;
    private int mergedCellCount = 1;
    private CellSelectionStrategy selectionManager = RangeSelectionStrategy.INSTANCE;
    protected GridCellValue<T> value;

    public BaseGridCell(GridCellValue<T> value) {
        this.value = value;
    }

    @Override
    public GridCellValue<T> getValue() {
        return this.value;
    }

    @Override
    public boolean isMerged() {
        return this.getMergedCellCount() != 1;
    }

    @Override
    public int getMergedCellCount() {
        return this.mergedCellCount;
    }

    @Override
    public boolean isCollapsed() {
        return this.collapseLevel > 0;
    }

    @Override
    public void collapse() {
        ++this.collapseLevel;
    }

    @Override
    public void expand() {
        --this.collapseLevel;
    }

    @Override
    public void reset() {
        this.mergedCellCount = 1;
        this.collapseLevel = 0;
    }

    @Override
    public CellSelectionStrategy getSelectionManager() {
        return this.selectionManager;
    }

    @Override
    public void setSelectionManager(CellSelectionStrategy selectionManager) {
        this.selectionManager = selectionManager;
    }

    void setValue(GridCellValue<T> value) {
        this.value = value;
    }

    void setMergedCellCount(int mergedCellCount) {
        this.mergedCellCount = mergedCellCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseGridCell)) {
            return false;
        }
        BaseGridCell that = (BaseGridCell)o;
        return !(this.value == null ? that.value != null : !this.value.equals(that.value));
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        return result;
    }
}

