/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.layer.impl;

import com.google.gwt.animation.client.AnimationScheduler;
import com.google.gwt.user.client.Command;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.uberfire.commons.validation.PortablePreconditions;

public class GridLayerRedrawManager {
    private static final GridLayerRedrawManager instance = new GridLayerRedrawManager();
    private static final Comparator<PrioritizedCommand> COMPARATOR = new Comparator<PrioritizedCommand>(){

        @Override
        public int compare(PrioritizedCommand o1, PrioritizedCommand o2) {
            return o1.getPriority() - o2.getPriority();
        }
    };
    private SortedSet<PrioritizedCommand> commands = new TreeSet<PrioritizedCommand>(COMPARATOR);
    private AnimationScheduler.AnimationCallback callback = new AnimationScheduler.AnimationCallback(){

        public void execute(double time) {
            SortedSet clone = GridLayerRedrawManager.this.commands;
            GridLayerRedrawManager.this.commands = new TreeSet(COMPARATOR);
            if (!clone.isEmpty()) {
                for (PrioritizedCommand command : clone) {
                    command.execute();
                }
            }
        }
    };

    public static final GridLayerRedrawManager get() {
        return instance;
    }

    private GridLayerRedrawManager() {
    }

    public void schedule(PrioritizedCommand command) {
        PortablePreconditions.checkNotNull((String)"command", (Object)command);
        if (!this.commands.contains(command)) {
            this.commands.add(command);
            this.kick();
        }
    }

    private void kick() {
        if (this.commands.size() > 0) {
            AnimationScheduler.get().requestAnimationFrame(this.callback);
        }
    }

    public static abstract class PrioritizedCommand
    implements Command {
        private int priority = 0;

        public PrioritizedCommand(int priority) {
            this.priority = priority;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

