/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.demo;

import com.ait.lienzo.client.core.types.Point2D;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.ext.wires.core.grids.client.demo.GridDataFactory;
import org.uberfire.ext.wires.core.grids.client.demo.WiresGridsDemoView;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseHeaderMetaData;
import org.uberfire.ext.wires.core.grids.client.widget.dom.multiple.impl.CheckBoxDOMElementFactory;
import org.uberfire.ext.wires.core.grids.client.widget.dom.single.impl.ListBoxSingletonDOMElementFactory;
import org.uberfire.ext.wires.core.grids.client.widget.dom.single.impl.TextBoxSingletonDOMElementFactory;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.BooleanDOMElementColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.ListBoxDOMElementSingletonColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.StringDOMElementSingletonColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.StringPopupColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.BaseGridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.BaseGridWidgetKeyboardHandler;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationClearCell;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationEditCell;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationMoveDown;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationMoveLeft;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationMoveRight;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationMoveUp;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationSelectBottomRightCell;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationSelectTopLeftCell;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.columns.GridColumnRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.columns.impl.StringColumnRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.themes.GridRendererTheme;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.themes.impl.MultiColouredTheme;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.themes.impl.RedTheme;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="WiresGridsDemoPresenter")
public class WiresGridsDemoPresenter
implements WiresGridsDemoView.Presenter {
    private static final int GRID1_ROWS = 100;
    private static final int GRID2_ROWS = 100;
    private static final int GRID3_ROWS = 2;
    private static final int GRID4_ROWS = 100;
    private Menus menus;
    private WiresGridsDemoView view;
    private GridWidget gridWidget1;
    private GridWidget gridWidget2;
    private GridWidget gridWidget3;
    private GridWidget gridWidget4;
    private TranslationService translationService;

    @Inject
    public WiresGridsDemoPresenter(WiresGridsDemoView view, TranslationService translationService) {
        this.view = view;
        this.translationService = translationService;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.translationService.getTranslation("Screen.Title");
    }

    @WorkbenchPartView
    public IsWidget getView() {
        return this.view;
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return this.menus;
    }

    @PostConstruct
    public void setup() {
        this.setupMenus();
        this.setupKeyDownHandler();
        this.setupZoomChangeHandler();
        this.setupStyleChangeHandler();
        this.setupMergedStateValueChangeHandler();
        this.setupAppendRowClickHandler();
        this.setupDeleteRowClickHandler();
        this.gridWidget1 = this.makeGridWidget1();
        this.gridWidget2 = this.makeGridWidget2();
        this.gridWidget3 = this.makeGridWidget3();
        this.gridWidget4 = this.makeGridWidget4();
        this.linkGrids(this.gridWidget1, 9, this.gridWidget2, 1);
        this.linkGrids(this.gridWidget2, 3, this.gridWidget3, 1);
        this.linkGrids(this.gridWidget3, 1, this.gridWidget1, 1);
        this.view.add(this.gridWidget1);
        this.view.add(this.gridWidget2);
        this.view.add(this.gridWidget3);
        this.view.add(this.gridWidget4);
    }

    private void linkGrids(GridWidget sourceGridWidget, int sourceGridColumnIndex, GridWidget targetGridWidget, int targetGridColumnIndex) {
        GridColumn<?> sourceGridColumn = sourceGridWidget.getModel().getColumns().get(sourceGridColumnIndex);
        GridColumn<?> targetGridColumn = targetGridWidget.getModel().getColumns().get(targetGridColumnIndex);
        sourceGridColumn.setLink(targetGridColumn);
    }

    private void setupMenus() {
        this.menus = ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)this.translationService.getTranslation("Menu.ClearSelections")).respondsWith(new Command(){

            public void execute() {
                for (GridWidget gridWidget : WiresGridsDemoPresenter.this.view.getGridWidgets()) {
                    if (!gridWidget.isSelected()) continue;
                    gridWidget.getModel().clearSelections();
                }
                WiresGridsDemoPresenter.this.view.refresh();
                ((MenuItem)WiresGridsDemoPresenter.this.menus.getItems().get(0)).setEnabled(false);
                ((MenuItem)WiresGridsDemoPresenter.this.menus.getItems().get(1)).setEnabled(false);
            }
        })).endMenu()).newTopLevelMenu(this.translationService.getTranslation("Menu.ClearCells")).respondsWith(new Command(){

            public void execute() {
                WiresGridsDemoPresenter.this.clearCells();
            }
        })).endMenu()).build();
        ((MenuItem)this.menus.getItems().get(0)).setEnabled(false);
        ((MenuItem)this.menus.getItems().get(1)).setEnabled(false);
    }

    private void setupKeyDownHandler() {
        GridLayer layer = this.view.getGridLayer();
        BaseGridWidgetKeyboardHandler handler = new BaseGridWidgetKeyboardHandler(this.view.getGridLayer());
        handler.addOperation(new KeyboardOperationClearCell(layer), new KeyboardOperationEditCell(layer), new KeyboardOperationMoveLeft(layer), new KeyboardOperationMoveRight(layer), new KeyboardOperationMoveUp(layer), new KeyboardOperationMoveDown(layer), new KeyboardOperationSelectTopLeftCell(layer), new KeyboardOperationSelectBottomRightCell(layer));
        this.view.addKeyDownHandler(handler);
    }

    private GridWidget makeGridWidget1() {
        BaseGridData grid1 = new BaseGridData(false);
        grid1.setHeaderRowCount(2);
        BaseGridWidget gridWidget1 = new BaseGridWidget(grid1, this, this.view.getGridLayer(), new BaseGridRenderer(new MultiColouredTheme()));
        RowNumberColumn grid1ColumnRowNumber = new RowNumberColumn();
        grid1.appendColumn(grid1ColumnRowNumber);
        BaseHeaderMetaData grid1ColumnFloatingHeaderMetaData = new BaseHeaderMetaData("Floating");
        TextBoxSingletonDOMElementFactory grid1ColumnFloatingFactory = new TextBoxSingletonDOMElementFactory(this.view.getGridPanel(), this.view.getGridLayer(), gridWidget1);
        StringDOMElementSingletonColumn grid1ColumnFloating = new StringDOMElementSingletonColumn((GridColumn.HeaderMetaData)grid1ColumnFloatingHeaderMetaData, grid1ColumnFloatingFactory, 100.0);
        grid1ColumnFloating.setMovable(false);
        grid1ColumnFloating.setResizable(true);
        grid1ColumnFloating.setFloatable(true);
        grid1.appendColumn(grid1ColumnFloating);
        for (int idx = 0; idx < 8; ++idx) {
            int grid1ColumnGroupSuffix = idx < 3 ? 0 : (idx < 6 ? 1 : 2);
            boolean isFloatable = idx == 0;
            BaseHeaderMetaData grid1ColumnHeaderMetaData1 = new BaseHeaderMetaData("G1-G" + grid1ColumnGroupSuffix + "-a-Long-Caption-1", "grid1ColumnGroup");
            BaseHeaderMetaData grid1ColumnHeaderMetaData2 = new BaseHeaderMetaData("G1-G" + grid1ColumnGroupSuffix + "-C" + idx + "-a-Long-Caption-2", "grid1ColumnGroup" + grid1ColumnGroupSuffix);
            ArrayList<GridColumn.HeaderMetaData> grid1ColumnHeaderMetaData = new ArrayList<GridColumn.HeaderMetaData>();
            grid1ColumnHeaderMetaData.add(grid1ColumnHeaderMetaData1);
            grid1ColumnHeaderMetaData.add(grid1ColumnHeaderMetaData2);
            StringPopupColumn grid1Column = new StringPopupColumn((List<GridColumn.HeaderMetaData>)grid1ColumnHeaderMetaData, (GridColumnRenderer<String>)new StringColumnRenderer(), 100.0);
            grid1Column.setMinimumWidth(50.0);
            grid1Column.setFloatable(isFloatable);
            grid1.appendColumn(grid1Column);
        }
        GridDataFactory.populate(grid1, 100);
        gridWidget1.setLocation(new Point2D(-1300.0, 0.0));
        return gridWidget1;
    }

    private GridWidget makeGridWidget2() {
        BaseGridData grid2 = new BaseGridData(false);
        BaseGridWidget gridWidget2 = new BaseGridWidget(grid2, this, this.view.getGridLayer(), new BaseGridRenderer(new MultiColouredTheme()){

            @Override
            public double getHeaderHeight() {
                return 64.0;
            }

            @Override
            public double getHeaderRowHeight() {
                return 64.0;
            }
        });
        for (int idx = 0; idx < 5; ++idx) {
            BaseHeaderMetaData grid2ColumnHeaderMetaData = new BaseHeaderMetaData("G2-G0-C" + idx);
            StringPopupColumn grid2Column = new StringPopupColumn((GridColumn.HeaderMetaData)grid2ColumnHeaderMetaData, (GridColumnRenderer<String>)new StringColumnRenderer(), 150.0);
            grid2.appendColumn(grid2Column);
        }
        GridDataFactory.populate(grid2, 100);
        gridWidget2.setLocation(new Point2D(0.0, 750.0));
        return gridWidget2;
    }

    private GridWidget makeGridWidget3() {
        BaseGridData grid3 = new BaseGridData(false);
        BaseGridWidget gridWidget3 = new BaseGridWidget(grid3, this, this.view.getGridLayer(), new BaseGridRenderer(new MultiColouredTheme()){

            @Override
            public double getHeaderHeight() {
                return 64.0;
            }

            @Override
            public double getHeaderRowHeight() {
                return 64.0;
            }
        });
        RowNumberColumn grid3RowNumberColumn = new RowNumberColumn();
        grid3.appendColumn(grid3RowNumberColumn);
        for (int idx = 0; idx < 2; ++idx) {
            boolean isResizeable = idx > 1;
            boolean isMovable = idx > 1;
            BaseHeaderMetaData grid3ColumnHeaderMetaData = new BaseHeaderMetaData("G3-G0-C" + idx);
            StringPopupColumn grid3Column = new StringPopupColumn((GridColumn.HeaderMetaData)grid3ColumnHeaderMetaData, (GridColumnRenderer<String>)new StringColumnRenderer(), 100.0);
            grid3Column.setResizable(isResizeable);
            grid3Column.setMovable(isMovable);
            grid3.appendColumn(grid3Column);
        }
        GridDataFactory.populate(grid3, 2);
        String grid3ColumnGroup1 = "grid3ColumnGroup1";
        BaseHeaderMetaData grid3Column2HeaderMetaData = new BaseHeaderMetaData("G3-G1-C2", "grid3ColumnGroup1");
        TextBoxSingletonDOMElementFactory grid3Column2Factory = new TextBoxSingletonDOMElementFactory(this.view.getGridPanel(), this.view.getGridLayer(), gridWidget3);
        StringDOMElementSingletonColumn grid3Column2 = new StringDOMElementSingletonColumn((GridColumn.HeaderMetaData)grid3Column2HeaderMetaData, grid3Column2Factory, 100.0);
        grid3.appendColumn(grid3Column2);
        for (int rowIndex = 0; rowIndex < 100; ++rowIndex) {
            grid3.setCell(rowIndex, 3, new BaseGridCellValue<String>("(2, " + rowIndex + ")"));
        }
        BaseHeaderMetaData grid3Column3HeaderMetaData = new BaseHeaderMetaData("G3-G1-C3", "grid3ColumnGroup1");
        CheckBoxDOMElementFactory grid3Column3Factory = new CheckBoxDOMElementFactory(this.view.getGridLayer(), gridWidget3);
        BooleanDOMElementColumn grid3Column3 = new BooleanDOMElementColumn((GridColumn.HeaderMetaData)grid3Column3HeaderMetaData, grid3Column3Factory, 100.0);
        grid3Column3.setFloatable(true);
        grid3.appendColumn(grid3Column3);
        for (int rowIndex = 0; rowIndex < 100; ++rowIndex) {
            grid3.setCell(rowIndex, 4, new BaseGridCellValue<Boolean>(Math.random() < GridDataFactory.FILL_FACTOR));
        }
        BaseHeaderMetaData grid3Column4HeaderMetaData = new BaseHeaderMetaData("G3-G1-C4", "grid3ColumnGroup1");
        ListBoxSingletonDOMElementFactory grid3Column4Factory = new ListBoxSingletonDOMElementFactory(this.view.getGridPanel(), this.view.getGridLayer(), gridWidget3);
        ListBoxDOMElementSingletonColumn grid3Column4 = new ListBoxDOMElementSingletonColumn((GridColumn.HeaderMetaData)grid3Column4HeaderMetaData, grid3Column4Factory, 100.0);
        grid3.appendColumn(grid3Column4);
        for (int rowIndex = 0; rowIndex < 100; ++rowIndex) {
            grid3.setCell(rowIndex, 5, new BaseGridCellValue<String>(rowIndex % 2 == 0 ? "one" : "two"));
        }
        gridWidget3.setLocation(new Point2D(1050.0, 0.0));
        return gridWidget3;
    }

    private GridWidget makeGridWidget4() {
        BaseGridData grid4 = new BaseGridData(false);
        BaseGridWidget gridWidget4 = new BaseGridWidget(grid4, this, this.view.getGridLayer(), new BaseGridRenderer(new RedTheme()){

            @Override
            public double getHeaderHeight() {
                return 64.0;
            }

            @Override
            public double getHeaderRowHeight() {
                return 64.0;
            }
        });
        BaseHeaderMetaData grid4Column1HeaderMetaData = new BaseHeaderMetaData("G4-G0-C0");
        StringPopupColumn grid4Column1 = new StringPopupColumn((GridColumn.HeaderMetaData)grid4Column1HeaderMetaData, (GridColumnRenderer<String>)new StringColumnRenderer(), 100.0);
        grid4.appendColumn(grid4Column1);
        BaseHeaderMetaData grid4Column2HeaderMetaData = new BaseHeaderMetaData("G4-G0-C1");
        CheckBoxDOMElementFactory grid4Column2Factory = new CheckBoxDOMElementFactory(this.view.getGridLayer(), gridWidget4);
        BooleanDOMElementColumn grid4Column2 = new BooleanDOMElementColumn((GridColumn.HeaderMetaData)grid4Column2HeaderMetaData, grid4Column2Factory, 100.0);
        grid4.appendColumn(grid4Column2);
        for (int rowIndex = 0; rowIndex < 100; ++rowIndex) {
            BaseGridRow row = new BaseGridRow();
            grid4.appendRow(row);
            block5: for (int columnIndex = 0; columnIndex < grid4.getColumnCount(); ++columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        if (!(Math.random() > 0.5)) continue block5;
                        grid4.setCell(rowIndex, columnIndex, new BaseGridCellValue<String>("(" + columnIndex + ", " + rowIndex + ")"));
                        continue block5;
                    }
                    case 1: {
                        grid4.setCell(rowIndex, columnIndex, new BaseGridCellValue<Boolean>(Math.random() < 0.5));
                    }
                }
            }
        }
        gridWidget4.setLocation(new Point2D(1800.0, 200.0));
        return gridWidget4;
    }

    private void setupZoomChangeHandler() {
        this.view.addZoomChangeHandler(new ChangeHandler(){
            private int m_currentZoom = 100;

            public void onChange(ChangeEvent event) {
                int pct = WiresGridsDemoPresenter.this.view.getSelectedZoomLevel();
                if (this.m_currentZoom == pct) {
                    return;
                }
                this.m_currentZoom = pct;
                WiresGridsDemoPresenter.this.view.setZoom(pct);
            }
        });
    }

    private void setupStyleChangeHandler() {
        this.view.addThemeChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                GridRendererTheme theme = WiresGridsDemoPresenter.this.view.getSelectedTheme();
                WiresGridsDemoPresenter.this.gridWidget4.getRenderer().setTheme(theme);
                WiresGridsDemoPresenter.this.view.refresh();
            }
        });
    }

    private void setupMergedStateValueChangeHandler() {
        this.view.setMergedState(false);
        this.view.addMergedStateValueChangeHandler(new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                boolean isMerged = (Boolean)event.getValue();
                WiresGridsDemoPresenter.this.gridWidget1.getModel().setMerged(isMerged);
                WiresGridsDemoPresenter.this.gridWidget2.getModel().setMerged(isMerged);
                WiresGridsDemoPresenter.this.gridWidget3.getModel().setMerged(isMerged);
                WiresGridsDemoPresenter.this.view.refresh();
            }
        });
    }

    private void setupAppendRowClickHandler() {
        this.view.addAppendRowClickHandler(event -> {
            for (GridWidget gridWidget : this.view.getGridWidgets()) {
                if (!gridWidget.isSelected()) continue;
                gridWidget.getModel().appendRow(new BaseGridRow());
            }
            this.view.refresh();
        });
    }

    private void setupDeleteRowClickHandler() {
        this.view.addDeleteRowClickHandler(event -> {
            for (GridWidget gridWidget : this.view.getGridWidgets()) {
                if (!gridWidget.isSelected() || gridWidget.getModel().getRowCount() <= 0) continue;
                gridWidget.getModel().deleteRow(0);
            }
            this.view.refresh();
        });
    }

    private void clearCells() {
        GridWidget selectedGridWidget = this.getSelectedGridWidget();
        if (selectedGridWidget == null) {
            return;
        }
        GridData gridModel = selectedGridWidget.getModel();
        List<GridData.SelectedCell> selectedCells = gridModel.getSelectedCells();
        for (GridData.SelectedCell cell : selectedCells) {
            gridModel.deleteCell(cell.getRowIndex(), cell.getColumnIndex());
        }
        this.view.refresh();
    }

    private GridWidget getSelectedGridWidget() {
        for (GridWidget gridWidget : this.view.getGridWidgets()) {
            if (!gridWidget.isSelected()) continue;
            return gridWidget;
        }
        return null;
    }

    @Override
    public void select(GridWidget selectedGridWidget) {
        this.view.select(selectedGridWidget);
        boolean hasSelections = selectedGridWidget.getModel().getSelectedCells().size() > 0;
        ((MenuItem)this.menus.getItems().get(0)).setEnabled(hasSelections);
        ((MenuItem)this.menus.getItems().get(1)).setEnabled(hasSelections);
    }

    @Override
    public void selectLinkedColumn(GridColumn<?> selectedGridColumn) {
        this.view.selectLinkedColumn(selectedGridColumn);
    }

    @Override
    public Set<GridWidget> getGridWidgets() {
        return this.view.getGridWidgets();
    }
}

