/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.animation;

import com.ait.lienzo.client.core.animation.AnimationTweener;
import com.ait.lienzo.client.core.animation.IAnimation;
import com.ait.lienzo.client.core.animation.IAnimationCallback;
import com.ait.lienzo.client.core.animation.IAnimationHandle;
import com.ait.lienzo.client.core.animation.TimedAnimation;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.client.core.types.Transform;
import com.google.gwt.user.client.Command;
import java.util.Set;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;

public class GridWidgetEnterPinnedModeAnimation
extends TimedAnimation {
    public GridWidgetEnterPinnedModeAnimation(final GridWidget gridWidget, final Set<GridWidget> gridWidgets, final Set<IPrimitive<?>> gridWidgetConnectors, final Command onStartCommand) {
        super(500.0, new IAnimationCallback(){
            private Point2D delta;
            private Point2D startTranslation;
            private double startScaleX;
            private double startScaleY;
            private final double endScaleX = 1.0;
            private final double endScaleY = 1.0;
            private AnimationTweener tweener = AnimationTweener.EASE_OUT;

            public void onStart(IAnimation animation, IAnimationHandle handle) {
                Viewport vp = gridWidget.getViewport();
                if (vp.getTransform() == null) {
                    vp.setTransform(new Transform());
                }
                this.startScaleX = vp.getTransform().getScaleX();
                this.startScaleY = vp.getTransform().getScaleY();
                this.startTranslation = this.getViewportTranslation().mul(-1.0);
                Point2D endTranslation = new Point2D(gridWidget.getX(), gridWidget.getY()).mul(-1.0);
                this.delta = new Point2D(endTranslation.getX() - this.startTranslation.getX(), endTranslation.getY() - this.startTranslation.getY());
                onStartCommand.execute();
                gridWidget.getLayer().setListening(false);
                gridWidget.getLayer().batch();
            }

            public void onFrame(IAnimation animation, IAnimationHandle handle) {
                double pct = this.assertPct(animation.getPercent());
                Viewport vp = gridWidget.getViewport();
                Transform transform = vp.getTransform();
                transform.reset();
                Point2D frameLocation = this.startTranslation.add(this.delta.mul(pct));
                double frameScaleX = this.startScaleX + (1.0 - this.startScaleX) * pct;
                double frameScaleY = this.startScaleY + (1.0 - this.startScaleY) * pct;
                transform.scale(frameScaleX, frameScaleY).translate(frameLocation.getX(), frameLocation.getY());
                this.hideGridWidgets(pct);
                this.hideGridWidgetConnectors(pct);
                gridWidget.getLayer().batch();
            }

            public void onClose(IAnimation animation, IAnimationHandle handle) {
                for (GridWidget gw : gridWidgets) {
                    gw.setVisible(false);
                }
                for (IPrimitive p : gridWidgetConnectors) {
                    p.setVisible(false);
                }
                gridWidget.getLayer().setListening(true);
                gridWidget.getLayer().batch();
            }

            private Point2D getViewportTranslation() {
                Viewport vp = gridWidget.getViewport();
                Transform transform = vp.getTransform();
                Transform t = transform.copy().getInverse();
                Point2D p = new Point2D(t.getTranslateX(), t.getTranslateY());
                return p;
            }

            private double assertPct(double pct) {
                if (pct < 0.0) {
                    return 0.0;
                }
                if (pct > 1.0) {
                    return 1.0;
                }
                return this.tweener.apply(pct);
            }

            private void hideGridWidgets(double pct) {
                for (GridWidget gw : gridWidgets) {
                    gw.setAlpha(1.0 - pct);
                }
            }

            private void hideGridWidgetConnectors(double pct) {
                for (IPrimitive p : gridWidgetConnectors) {
                    p.setAlpha(1.0 - pct);
                }
            }
        });
    }
}

