/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.impl;

import com.ait.lienzo.client.core.Context2D;
import com.ait.lienzo.client.core.event.NodeMouseClickEvent;
import com.ait.lienzo.client.core.event.NodeMouseClickHandler;
import com.ait.lienzo.client.core.event.NodeMouseDoubleClickHandler;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.types.BoundingBox;
import com.ait.lienzo.client.core.types.Point2D;
import com.google.gwt.event.shared.GwtEvent;
import java.util.ArrayList;
import java.util.List;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridHeaderRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.dnd.GridWidgetDnDHandlersState;
import org.uberfire.ext.wires.core.grids.client.widget.dom.HasDOMElementResources;
import org.uberfire.ext.wires.core.grids.client.widget.dom.multiple.HasMultipleDOMElementResources;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.BaseGridWidgetMouseClickHandler;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.BaseGridWidgetMouseDoubleClickHandler;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.GridCellSelectorMouseClickHandler;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.SelectionsTransformer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.DefaultSelectionsTransformer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.FloatingSelectionsTransformer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.CellSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.SelectionExtension;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.impl.BaseCellSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.DefaultGridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;

public class BaseGridWidget
extends Group
implements GridWidget {
    protected final SelectionsTransformer bodyTransformer;
    protected final SelectionsTransformer floatingColumnsTransformer;
    protected final BaseGridRendererHelper rendererHelper;
    protected final List<GridColumn<?>> allColumns = new ArrayList();
    protected final List<GridColumn<?>> bodyColumns = new ArrayList();
    protected final List<GridColumn<?>> floatingColumns = new ArrayList();
    protected GridData model;
    protected GridRenderer renderer;
    protected Group header = null;
    protected Group floatingHeader = null;
    protected Group body = null;
    protected Group floatingBody = null;
    private Group selection = null;
    private boolean isSelected = false;
    private final CellSelectionManager cellSelectionManager;

    public BaseGridWidget(GridData model, GridSelectionManager selectionManager, GridPinnedModeManager pinnedModeManager, GridRenderer renderer) {
        this.model = model;
        this.renderer = renderer;
        this.bodyTransformer = new DefaultSelectionsTransformer(model, this.bodyColumns);
        this.floatingColumnsTransformer = new FloatingSelectionsTransformer(model, this.floatingColumns);
        this.rendererHelper = this.getBaseGridRendererHelper();
        this.cellSelectionManager = this.getCellSelectionManager();
        this.addNodeMouseClickHandler(this.getGridMouseClickHandler(selectionManager));
        this.addNodeMouseClickHandler(this.getGridMouseCellSelectorClickHandler(selectionManager));
        this.addNodeMouseDoubleClickHandler(this.getGridMouseDoubleClickHandler(selectionManager, pinnedModeManager));
        this.addNodeDragEndHandler(event -> {
            GridWidgetDnDHandlersState state = ((DefaultGridLayer)this.getLayer()).getGridWidgetHandlersState();
            state.reset();
            this.getViewport().getElement().getStyle().setCursor(state.getCursor());
        });
    }

    BaseGridRendererHelper getBaseGridRendererHelper() {
        return new BaseGridRendererHelper(this);
    }

    CellSelectionManager getCellSelectionManager() {
        return new BaseCellSelectionManager(this);
    }

    NodeMouseClickHandler getGridMouseClickHandler(GridSelectionManager selectionManager) {
        return new BaseGridWidgetMouseClickHandler(this, selectionManager, this.renderer);
    }

    NodeMouseClickHandler getGridMouseCellSelectorClickHandler(GridSelectionManager selectionManager) {
        return new GridCellSelectorMouseClickHandler(this, selectionManager, this.renderer);
    }

    NodeMouseDoubleClickHandler getGridMouseDoubleClickHandler(GridSelectionManager selectionManager, GridPinnedModeManager pinnedModeManager) {
        return new BaseGridWidgetMouseDoubleClickHandler(this, selectionManager, pinnedModeManager, this.renderer);
    }

    @Override
    public GridData getModel() {
        return this.model;
    }

    @Override
    public GridRenderer getRenderer() {
        return this.renderer;
    }

    @Override
    public void setRenderer(GridRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public BaseGridRendererHelper getRendererHelper() {
        return this.rendererHelper;
    }

    @Override
    public Group getBody() {
        return this.body;
    }

    @Override
    public Group getHeader() {
        return this.header;
    }

    @Override
    public double getWidth() {
        return this.rendererHelper.getWidth(this.model.getColumns());
    }

    @Override
    public double getHeight() {
        double height = this.renderer.getHeaderHeight();
        return height += this.rendererHelper.getRowOffset(this.model.getRowCount());
    }

    @Override
    public void select() {
        this.isSelected = true;
        BaseGridRendererHelper.RenderingInformation renderingInformation = this.rendererHelper.getRenderingInformation();
        if (renderingInformation == null) {
            return;
        }
        this.assertSelectionWidget(renderingInformation);
        this.add((IPrimitive)this.selection);
    }

    @Override
    public void deselect() {
        this.isSelected = false;
        if (this.selection != null) {
            this.remove((IPrimitive)this.selection);
        }
    }

    @Override
    public boolean isSelected() {
        return this.isSelected;
    }

    private void assertSelectionWidget(BaseGridRendererHelper.RenderingInformation renderingInformation) {
        this.selection = this.renderer.renderSelector(this.getWidth(), this.getHeight(), renderingInformation);
    }

    protected void drawWithoutTransforms(Context2D context, double alpha, BoundingBox bb) {
        this.body = null;
        this.header = null;
        this.floatingBody = null;
        this.floatingHeader = null;
        if (context.isSelection() && !this.isListening()) {
            return;
        }
        if ((alpha *= this.getAttributes().getAlpha()) <= 0.0) {
            return;
        }
        if (this.model.getColumns().isEmpty()) {
            return;
        }
        this.removeAll();
        this.allColumns.clear();
        this.bodyColumns.clear();
        this.floatingColumns.clear();
        BaseGridRendererHelper.RenderingInformation renderingInformation = this.rendererHelper.getRenderingInformation();
        if (renderingInformation == null) {
            this.destroyDOMElementResources();
            return;
        }
        BaseGridRendererHelper.RenderingBlockInformation bodyBlockInformation = renderingInformation.getBodyBlockInformation();
        BaseGridRendererHelper.RenderingBlockInformation floatingBlockInformation = renderingInformation.getFloatingBlockInformation();
        List<GridColumn<?>> allColumns = renderingInformation.getAllColumns();
        List<GridColumn<?>> bodyColumns = bodyBlockInformation.getColumns();
        List<GridColumn<?>> floatingColumns = floatingBlockInformation.getColumns();
        boolean isSelectionLayer = context.isSelection();
        this.allColumns.addAll(allColumns);
        this.bodyColumns.addAll(bodyColumns);
        this.floatingColumns.addAll(floatingColumns);
        if (!isSelectionLayer) {
            for (GridColumn<?> column : this.model.getColumns()) {
                if (bodyColumns.contains(column) || floatingColumns.contains(column)) {
                    if (!(column instanceof HasMultipleDOMElementResources)) continue;
                    ((HasMultipleDOMElementResources)((Object)column)).initialiseResources();
                    continue;
                }
                if (!(column instanceof HasDOMElementResources)) continue;
                ((HasDOMElementResources)((Object)column)).destroyResources();
            }
        }
        if (this.bodyColumns.size() > 0) {
            this.drawHeader(renderingInformation, isSelectionLayer);
            if (this.model.getRowCount() > 0) {
                this.drawBody(renderingInformation, isSelectionLayer);
            }
            if (this.body != null) {
                this.add((IPrimitive)this.body);
            }
            if (this.header != null) {
                this.add((IPrimitive)this.header);
            }
            if (this.body != null || this.header != null) {
                this.add((IPrimitive)this.renderGridBoundary(bodyColumns, bodyBlockInformation.getX(), renderingInformation));
            }
            if (this.floatingBody != null) {
                this.add((IPrimitive)this.floatingBody);
            }
            if (this.floatingHeader != null) {
                this.add((IPrimitive)this.floatingHeader);
            }
            if (this.floatingBody != null || this.floatingHeader != null) {
                this.add((IPrimitive)this.renderGridBoundary(floatingColumns, floatingBlockInformation.getX(), renderingInformation));
            }
            if (this.isSelected) {
                this.assertSelectionWidget(renderingInformation);
                this.add((IPrimitive)this.selection);
            }
        }
        if (!isSelectionLayer) {
            for (GridColumn<?> column : bodyColumns) {
                if (!(column instanceof HasMultipleDOMElementResources)) continue;
                ((HasMultipleDOMElementResources)((Object)column)).freeUnusedResources();
            }
            for (GridColumn<?> column : floatingColumns) {
                if (!(column instanceof HasMultipleDOMElementResources)) continue;
                ((HasMultipleDOMElementResources)((Object)column)).freeUnusedResources();
            }
        }
        super.drawWithoutTransforms(context, alpha, bb);
    }

    void destroyDOMElementResources() {
        for (GridColumn<?> column : this.model.getColumns()) {
            if (!(column.getColumnRenderer() instanceof HasDOMElementResources)) continue;
            ((HasDOMElementResources)((Object)column.getColumnRenderer())).destroyResources();
        }
    }

    public Group setVisible(boolean visible) {
        if (!visible) {
            for (GridColumn<?> gc : this.getModel().getColumns()) {
                if (!(gc instanceof HasMultipleDOMElementResources)) continue;
                ((HasMultipleDOMElementResources)((Object)gc)).destroyResources();
            }
        }
        return (Group)super.setVisible(visible);
    }

    protected void drawHeader(BaseGridRendererHelper.RenderingInformation renderingInformation, boolean isSelectionLayer) {
        List<GridColumn<?>> allColumns = renderingInformation.getAllColumns();
        BaseGridRendererHelper.RenderingBlockInformation bodyBlockInformation = renderingInformation.getBodyBlockInformation();
        BaseGridRendererHelper.RenderingBlockInformation floatingBlockInformation = renderingInformation.getFloatingBlockInformation();
        List<GridColumn<?>> bodyColumns = bodyBlockInformation.getColumns();
        List<GridColumn<?>> floatingColumns = floatingBlockInformation.getColumns();
        double headerX = bodyBlockInformation.getX();
        double headerY = bodyBlockInformation.getHeaderY();
        double floatingHeaderX = floatingBlockInformation.getX();
        double floatingHeaderY = floatingBlockInformation.getHeaderY();
        boolean addFixedHeader = renderingInformation.isFixedHeader();
        boolean addFloatingHeader = renderingInformation.isFloatingHeader();
        if (addFixedHeader || addFloatingHeader) {
            this.header = this.renderGridHeaderWidget(allColumns, bodyColumns, isSelectionLayer, renderingInformation);
            this.header.setX(headerX);
            if (addFloatingHeader) {
                this.header.setY(headerY);
            }
            if (floatingColumns.size() > 0) {
                this.floatingHeader = this.renderGridHeaderWidget(floatingColumns, floatingColumns, isSelectionLayer, renderingInformation);
                this.floatingHeader.setX(floatingHeaderX);
                this.floatingHeader.setY(floatingHeaderY);
            }
        }
    }

    protected void drawBody(BaseGridRendererHelper.RenderingInformation renderingInformation, boolean isSelectionLayer) {
        BaseGridRendererHelper.RenderingBlockInformation bodyBlockInformation = renderingInformation.getBodyBlockInformation();
        BaseGridRendererHelper.RenderingBlockInformation floatingBlockInformation = renderingInformation.getFloatingBlockInformation();
        List<GridColumn<?>> bodyColumns = bodyBlockInformation.getColumns();
        List<GridColumn<?>> floatingColumns = floatingBlockInformation.getColumns();
        double bodyX = bodyBlockInformation.getX();
        double bodyY = bodyBlockInformation.getBodyY();
        double floatingBodyX = floatingBlockInformation.getX();
        double floatingBodyY = floatingBlockInformation.getBodyY();
        int minVisibleRowIndex = renderingInformation.getMinVisibleRowIndex();
        int maxVisibleRowIndex = renderingInformation.getMaxVisibleRowIndex();
        this.body = this.renderGridBodyWidget(bodyColumns, bodyBlockInformation.getX(), minVisibleRowIndex, maxVisibleRowIndex, isSelectionLayer, this.bodyTransformer, renderingInformation);
        this.body.setX(bodyX);
        this.body.setY(bodyY);
        if (!isSelectionLayer) {
            this.body.add((IPrimitive)this.renderSelectedRanges(bodyColumns, bodyBlockInformation.getX(), minVisibleRowIndex, maxVisibleRowIndex, this.bodyTransformer, renderingInformation));
        }
        if (floatingColumns.size() > 0) {
            this.floatingBody = this.renderGridBodyWidget(floatingColumns, floatingBlockInformation.getX(), minVisibleRowIndex, maxVisibleRowIndex, isSelectionLayer, this.floatingColumnsTransformer, renderingInformation);
            this.floatingBody.setX(floatingBodyX);
            this.floatingBody.setY(floatingBodyY);
            if (!isSelectionLayer) {
                this.floatingBody.add((IPrimitive)this.renderSelectedRanges(floatingColumns, floatingBlockInformation.getX(), minVisibleRowIndex, maxVisibleRowIndex, this.floatingColumnsTransformer, renderingInformation));
            }
        }
    }

    protected Group renderGridHeaderWidget(List<GridColumn<?>> allColumns, List<GridColumn<?>> blockColumns, boolean isSelectionLayer, BaseGridRendererHelper.RenderingInformation renderingInformation) {
        GridHeaderRenderContext context = new GridHeaderRenderContext(allColumns, blockColumns, isSelectionLayer);
        Group g = this.renderer.renderHeader(this.model, context, this.rendererHelper, renderingInformation);
        return g;
    }

    protected Group renderGridBodyWidget(List<GridColumn<?>> blockColumns, double absoluteColumnOffsetX, int minVisibleRowIndex, int maxVisibleRowIndex, boolean isSelectionLayer, SelectionsTransformer transformer, BaseGridRendererHelper.RenderingInformation renderingInformation) {
        BaseGridRendererHelper.RenderingBlockInformation floatingBlockInformation = renderingInformation.getFloatingBlockInformation();
        double floatingX = floatingBlockInformation.getX();
        double floatingWidth = floatingBlockInformation.getWidth();
        double clipMinY = this.getY() + (this.header == null ? 0.0 : this.header.getY() + this.getRenderer().getHeaderHeight());
        double clipMinX = this.getX() + floatingX + floatingWidth;
        GridBodyRenderContext context = new GridBodyRenderContext(this.getX(), this.getY(), absoluteColumnOffsetX, clipMinY, clipMinX, minVisibleRowIndex, maxVisibleRowIndex, blockColumns, isSelectionLayer, this.getViewport().getTransform(), this.renderer, transformer);
        Group g = this.renderer.renderBody(this.model, context, this.rendererHelper, renderingInformation);
        return g;
    }

    protected Group renderGridBoundary(List<GridColumn<?>> blockColumns, double absoluteColumnOffsetX, BaseGridRendererHelper.RenderingInformation renderingInformation) {
        double headerYOffset = this.header == null ? 0.0 : this.header.getY();
        double headerRowsYOffset = renderingInformation.getHeaderRowsYOffset();
        Group boundary = this.renderer.renderGridBoundary(this.rendererHelper.getWidth(blockColumns), this.getHeight() - headerRowsYOffset - headerYOffset);
        boundary.setY(headerRowsYOffset + headerYOffset);
        boundary.setX(absoluteColumnOffsetX);
        this.add((IPrimitive)boundary);
        return boundary;
    }

    protected Group renderSelectedRanges(List<GridColumn<?>> blockColumns, double absoluteColumnOffsetX, int minVisibleRowIndex, int maxVisibleRowIndex, SelectionsTransformer transformer, BaseGridRendererHelper.RenderingInformation renderingInformation) {
        BaseGridRendererHelper.RenderingBlockInformation floatingBlockInformation = renderingInformation.getFloatingBlockInformation();
        double floatingX = floatingBlockInformation.getX();
        double floatingWidth = floatingBlockInformation.getWidth();
        double clipMinY = this.getY() + (this.header == null ? 0.0 : this.header.getY() + this.getRenderer().getHeaderHeight());
        double clipMinX = this.getX() + floatingX + floatingWidth;
        GridBodyRenderContext context = new GridBodyRenderContext(this.getX(), this.getY(), absoluteColumnOffsetX, clipMinY, clipMinX, minVisibleRowIndex, maxVisibleRowIndex, blockColumns, false, this.getViewport().getTransform(), this.renderer, transformer);
        Group g = this.renderer.renderSelectedCells(this.model, context, this.rendererHelper);
        return g;
    }

    public void onNodeMouseClick(NodeMouseClickEvent event) {
        this.fireEvent((GwtEvent)event);
    }

    @Override
    public boolean onGroupingToggle(double cellX, double cellY, double cellWidth, double cellHeight) {
        return this.renderer.onGroupingToggle(cellX, cellY, cellWidth, cellHeight);
    }

    @Override
    public boolean selectCell(Point2D ap, boolean isShiftKeyDown, boolean isControlKeyDown) {
        return this.cellSelectionManager.selectCell(ap, isShiftKeyDown, isControlKeyDown);
    }

    @Override
    public boolean selectCell(int uiRowIndex, int uiColumnIndex, boolean isShiftKeyDown, boolean isControlKeyDown) {
        return this.cellSelectionManager.selectCell(uiRowIndex, uiColumnIndex, isShiftKeyDown, isControlKeyDown);
    }

    @Override
    public boolean adjustSelection(SelectionExtension direction, boolean isShiftKeyDown) {
        return this.cellSelectionManager.adjustSelection(direction, isShiftKeyDown);
    }

    @Override
    public boolean startEditingCell(int uiRowIndex, int uiColumnIndex) {
        return this.cellSelectionManager.startEditingCell(uiRowIndex, uiColumnIndex);
    }

    @Override
    public boolean startEditingCell(Point2D ap) {
        return this.cellSelectionManager.startEditingCell(ap);
    }
}

